//"intedkfk.sci","Integracja DK do FK - include","\Integracja z FK a\",0,1.0.28,SYSTEM
////////////////////
// intedkfk.sci
// Integracja DK do FK - include
#define APOSTROF				"\t"

#define NIE_EKSP_OZNAK			0x2

#define BFLAGdpDOKOMPL			0x4000		// pozycja z kompletu
#define lOPIS	200
//#define DOK_PUSTAOPER			0x20		// analogicznie po stronie FK  , nie wysyamy flagi, bazujemy na typach dokumentw FK

Dispatch xConnection
Dispatch xRecordSet
Dispatch xTypDok
String   dataRejestrVATzbiorczy

Int Sub RownolegleKsMg(Int iOpcje, Dispatch xDokumentSp, Dispatch xTypDokumentuSp, Int bKorekta, Int nWalutowy, Int dodajZapis, Int zapiszZapis, Int zbiorczy)

	Int zapisano = 0
	Int uwzglednij

	if !bKorekta then
		for ii=1 to ii>xDokumentSp.transakcjaTw.powiazaniaTw.Count()
			nRes=!(xDokumentMg=GetObjById("BDokumentMg",xDokumentSp.transakcjaTw.powiazaniaTw.item(ii).idWlascicielaTrans))
			if nRes then  error "Dokument nie zaadowany"
			uwzglednij = !((iOpcje & NIE_EKSP_OZNAK) && xDokumentMg.czyWyeksportFK)
			if ( xDokumentMg.czyWystawiony && !IntegrZatwWart(xDokumentMg, xDokumentSp.numer, uwzglednij) ) then
				if uwzglednij then
					If !dodajZapis Then
						xDekretacjeMg.Clear()
					EndIf
					xDekretParams = xDekretacjeMg.Params()
					xDekretParams.id = xDokumentMg.id
					xDekretParams.dodaj = dodajZapis
					xDekretacjeMg.Dekret(xDekretParams)

					If dodajZapis Then
						xDekretacjeMg.Optymalizuj()
					EndIf
					If zapiszZapis Then
						if(xTypDokumentuSp.typFK == "FWS" || xTypDokumentuSp.typFK == "FWSK")  then //nowy typ dokumentu w FK - wielowalutowy
						//ewentualne rownolegle ksiegowanie magazynowe tylko w PLN
							ZapiszZAP(xDekretacjeMg, 1, 0, 0, xDokumentMg.termin, 0, "", 0, 0)
						else
							ZapiszZAP(xDekretacjeMg, 1, 0, 0, xDokumentMg.termin, nWalutowy, xDokumentSp.waluta, 0, 0)
						endif
						zapisano = 1
					Else
						zbiorczyTermin = xDokumentMg.termin
					EndIf
				else
					eksport.AddInfo("Nie mona powtrnie wyeksportowa zapisw do dokumentu " + xDokumentMg.numer + ".")
				endif
			endif
		next ii
	endif
	//korekta i inne korekty
	for ii=1 to ii>xDokumentSp.zwiazkiOdpDok.Count()
		if ((xDokumentSp.zwiazkiOdpDok.item(ii).dkBase == 33) && xDokumentSp.zwiazkiOdpDok.item(ii).idDk) then
			nRes=!(xDokumentMg=GetObjById("BDokumentMg",xDokumentSp.zwiazkiOdpDok.item(ii).idDk))
			if nRes then  error "Dokument nie zaadowany"
			uwzglednij = !((iOpcje & NIE_EKSP_OZNAK) && xDokumentMg.czyWyeksportFK)
			if ( xDokumentMg.czyWystawiony && !IntegrZatwWart(xDokumentMg, xDokumentSp.numer, uwzglednij) ) then
				if uwzglednij then
					If !dodajZapis Then
						xDekretacjeMg.Clear()
					EndIf
					xDekretParams = xDekretacjeMg.Params()
					xDekretParams.id = xDokumentMg.id
					xDekretParams.dodaj = dodajZapis
					xDekretacjeMg.Dekret(xDekretParams)

					If dodajZapis Then
						xDekretacjeMg.Optymalizuj()
					EndIf
					If zapiszZapis Then
					if(xTypDokumentuSp.typFK == "FWS" || xTypDokumentuSp.typFK == "FWSK")  then //nowy typ dokumentu w FK - wielowalutowy
						//ewentualne rownolegle ksiegowanie magazynowe tylko w PLN
							ZapiszZAP(xDekretacjeMg, 1, 0, 0, xDokumentMg.termin, 0, "", 0, 0)
						else
							ZapiszZAP(xDekretacjeMg, 1, 0, 0, xDokumentMg.termin, nWalutowy, xDokumentSp.waluta, 0, 0)
						endif
						zapisano = 1
					Else
						zbiorczyTermin = xDokumentMg.termin
					EndIf
				else
					eksport.AddInfo("Nie mona powtrnie wyeksportowa zapisw do dokumentu " + xDokumentMg.numer + ".")
				endif
			endif
		endif
	next ii
	If zapiszZapis && zbiorczy && !zapisano Then
		ZapiszZAP(xDekretacjeMg, 1, 0, 0, zbiorczyTermin, 0, "", 0, 0)
	EndIf
EndSub

Int Sub OznaczajEkspFK( Long idDK )

	Dispatch xDokMg, xDokSp, xDokumentMg, xDokumentSp
	Long     ii

	If !(xDokumentSp = GetObjById("BDokumentSp", idDK)) Then Error "Brak takiego rekordu w bazie DK"
	If !(xDokSp = GetObjById("BDokSp", idDK)) Then           Error "Dokument nie zaadowany"

	xDokSp.SetEkspFK()

	// dokumenty magazynowe rozliczajce dokument handlowy
	If iRownoKsiegMag Then
		If !xDokumentSp.czyKorekta Then
			xDokumentSp.transakcjaTw.powiazaniaTw.PokazujIstniejace()
			For ii=1 To ii>xDokumentSp.transakcjaTw.powiazaniaTw.Count()
				If !(xDokumentMg=GetObjById("BDokumentMg",xDokumentSp.transakcjaTw.powiazaniaTw.item(ii).idWlascicielaTrans)) Then Error "Dokument nie zaadowany"
				If (xDokumentMg.czyWystawiony) Then
					If !(xDokMg=GetObjById("BDokMg",xDokumentMg.id)) Then Error "Dokument nie zaadowany"
					xDokMg.SetEkspFK()
				EndIf
			Next ii
		EndIf
		For ii=1 To ii>xDokumentSp.zwiazkiOdpDok.Count()
			If ((xDokumentSp.zwiazkiOdpDok.item(ii).dkBase == 33) && xDokumentSp.zwiazkiOdpDok.item(ii).idDk) Then
				If !(xDokumentMg=GetObjById("BDokumentMg",xDokumentSp.zwiazkiOdpDok.item(ii).idDk)) Then Error "Dokument nie zaadowany"
				if (xDokumentMg.czyWystawiony) then
					If !(xDokMg=GetObjByID("BDokMg",xDokumentMg.id)) Then Error "Dokument nie zaadowany"
					xDokMg.SetEkspFK()
				EndIf
			EndIf
		Next ii
	EndIf

EndSub

int Sub IntegrDK(long idDK, int iOpcje)
	Dispatch xRozrachunek
	Dispatch xKZ

	IntegrDK = 0

	string sTyp
	int err
	int bKorekta = 0, bRozliczony
	int nCount = 1
	int nPozycja = 0
	dispatch dpStVat
	int iRejVat, iPom, iPomStVat, iPos
	int index = 1
	int IDFK_K
	String strOkres
	float dKwota, dKurs
	string sRej,sParam
	long lSuper
	String strTmp
	int iSubtyp, nWalutowy
	int iRok, iRok2
	long ii
	Dispatch xKontrahent
	Dispatch xDokSp
	Dispatch xTypDokumentuSp
	Dispatch xKsSchematSp
	Dispatch xTowar
	Dispatch xParams
	Dispatch xDefDok
	int czyRelatedDokument = 0
	string xmlDoc, s1,s2
	int iOkresSter, k
	int czyPozycjaVAT = 0, czyDEX = 0
	String sRequest
	Dispatch connFT = GetAdoConnection()
	Dispatch rsFT = "ADODB.Recordset"
	Long     rejestrID

	// zerowa faktura zaliczkowa koncowa nie ma pozycji
	// id rejestru odczytywane z dokumentu
	Int iRejVatZFK = 0

	Dispatch xIntegracja = xFactory.GetObject("BIntegracjaFK")

	If iRownoKsiegMag Then
		// wydanie reczne po wystawieniu sprzedazy
		// dokument w factory nie ma uaktualnionej informacji o wydaniach
		// trzeba powolac nowy obiekt
		nRes=!(xDokumentSp=GetNewObjById("BDokumentSp",idDK))
	Else
		// ze wzgledow pamieciowych po staremu
		nRes=!(xDokumentSp=GetObjById("BDokumentSp",idDK))
	EndIf
	if nRes then  Error "Brak takiego rekordu w bazie DK"

	iSubtyp = xDokumentSp.charakter

	if iSubtyp == SKO || iSubtyp == SKK || iSubtyp == SKW || iSubtyp == SKWK then
		buf = xDokumentSp.dataRealizacji
		iRok = dbd.firmainfo.GetRokByDate(xDokumentSp.dataRealizacji)
	else
		//  na podstawie definicji typu dokumentu w FK okreslamy rok dla wszystkich pozostaych dokumentow
		buf = xDokumentSp.dataWystawienia
		iRok2 = dbd.firmainfo.GetRokByDate(xDokumentSp.dataWystawienia)
		if iRok2 == -3 then  //rok zamkniety
			IntegrDK = ZamknietyRok(1, xDokumentSp.numer, buf, idDK)
			if IntegrDK then exit
		endif
		xTypDokumentuSp = GetObjByKod("BTypDokumentuSp", xDokumentSp.typDK)
		if !xTypDokumentuSp then  error "Brak takiego rekordu"
		sParam = using "%d", iRok2
		xDefDok.Create(ObjectFK(".DefDokum"))
		xDefDok.Open(sParam, dbd)
		xDefDok.MoveTo(xTypDokumentuSp.typFK)
		iOkresSter = xDefDok.Value("konfOkres")
		if iOkresSter == 1 && ( xDokumentSp.dataSprzedazy != "" || !xDokumentSp.PustaDataSprzedazy ) then//data operacji gospodarczej
			iRok = dbd.firmainfo.GetRokByDate(xDokumentSp.dataSprzedazy)
			if iRok == -3 then //warning
				IntegrDK = ZamknietyRok2(1, xDokumentSp.numer, xDokumentSp.dataSprzedazy, idDK, 1)
				if IntegrDK then exit
				iRok = dbd.firmainfo.GetRokByDate(xDokumentSp.dataWystawienia) //data dokumentu
			endif
		else
			iRok = dbd.firmainfo.GetRokByDate(xDokumentSp.dataWystawienia) //data dokumentu
		endif
	endif

	if iRok < 0 then
		IntegrDK = ZamknietyRok(1, xDokumentSp.numer, buf, idDK)
		if IntegrDK then exit
	endif

	if RokFK(1).Zap == 1 then

		if RokFK(1).IdRok != iRok then
			UstawRok(iRok)
		endif

	else
		UstawRok(iRok)
	endif

	dst=RokFK(1).Rok
	plkn=RokFK(1).PlanKont
	defdok=RokFK(1).DefDokument
	rozrDokument=RokFK(1).RokDokumentRoz

	Select Case xDokumentSp.charakter
	Case DXK, DEX, WDT, WDK, REX, RXK, FVS, FKS ,FVW, FKW, FVT, FTK
		if ItgInfo.Info("PozycjaVAT") then czyPozycjaVAT = 1
		if xDokumentSp.charakter == DEX || xDokumentSp.charakter == DXK then	czyDEX = 1
	Case Else
			czyPozycjaVAT = 0
	EndSelect

	// sprawdzamy typ dokumentu
	Select Case xDokumentSp.charakter
		Case FVS, FKS, RUS, RKS, DXK, DEX, FAS, FAK, PAR, PRK, FVW, FKW, FZS, ZKS, WDT, FWS, WKS, WDK, FVT, FTK, REX, RXK, SZA, SZK, SKO, SKK, SKW, SKWK, SZW, SZWK
		Case Else
			IntegrDK = 1 // pomijamy
			AddUniqueError("Nie mona wysa dokumentu " + xDokumentSp.numer+".",idDK)
	EndSelect

	// sprawdzamy czy zawarty w ro
	if(xDokumentSp.IdPeriodicSaleReport != 0) then
		IntegrDK = 1 // pomijamy
		AddInfo("Nie mona wyeksportowa dokumentu " + xDokumentSp.numer + ". Dokument jest zawarty w raporcie okresowym.")
	endif	

	if ( IntegrDK == 1 ) then Exit

	//dla wspolnej bazy - sprawdzamy czy dokument, zostal zapisany w RDF
	if (xIntegracja.CzyItgXML == 1 && !xDokumentSp.statusRDF) then
		if CzyIntegrSentToFK(xDokumentSp.numer, idDK) then Exit // pomijamy
	endif

	if CzyIntegrBrakSchematu(xDokumentSp.schematKsiegowania, xDokumentSp.numer, idDK) then
		IntegrDK = 1 // pomijamy
		Exit
	endif

	xKsSchematSp = GetObjByKod("BKsSchematSp", xDokumentSp.schematKsiegowania)
	if xKsSchematSp then
		nRes = 0
	else
		nRes = 1
	endif

	if CzyIntegrBlednySchemat(nRes, xDokumentSp.numer, idDK) then
		IntegrDK = 1 // pomijamy
		Exit
	endif

	if 0 != xDokumentSp.danekh.KhId then

		xKontrahent = GetObjById("BKontrahent", xDokumentSp.danekh.KhId)
		if !xKontrahent then  error "Brak takiego rekordu w bazie KH"

		if ( 1 != xIntegracja.trybWspolpracy && 4 != xIntegracja.trybWspolpracy) then
			IntegrDK = CzyIntegrBrakIDFK(val(xKontrahent.identyfikatorFK), xDokumentSp.numer, idDK)
			if IntegrDK then exit
		endif
	endif

	sTyp = xDokumentSp.typDk


	nRes = !(xDokSp=GetObjById("BDokSp",idDK))
	if nRes then  error "Dokument nie zaadowany"
	if xDokSp.czyZaimport then
		//dokument moze miec typ dokumentu wprowadzony tylko w centrali
		// sprawdzamy czy ma taki typ

		xTypDokumentuSp = GetObjByKod("BTypDokumentuSp", xDokumentSp.typDk)

		sTyp = ""
		if xTypDokumentuSp && (xDokumentSp.charakter == xTypDokumentuSp.charakter) then
			// typ dokumentu pasuje z odzdialu z centrala
			sTyp = xDokumentSp.typDk
		else
			// nie znaleizono typu o takim kodzie wiec
			// szukamy dla podstawowego typu dla charakteru dokumentu
			xTypDokumentuSp = GetObjByKod("BTypDokumentuSp", TypDOK(xDokumentSp.charakter))
			if xTypDokumentuSp && (xDokumentSp.charakter == xTypDokumentuSp.charakter) then
				sTyp = xDokumentSp.typDk
			else
				IntegrDK = CzyIntegrBrakTypDK("", xDokumentSp.numer, idDK, TypDOK(xDokumentSp.charakter))
			endif
		endif
	endif


	if !(xDokSp.czyZaimport) || ((xDokSp.czyZaimport) && sTyp != "") then

		xTypDokumentuSp = GetObjByKod("BTypDokumentuSp", sTyp)
		if !xTypDokumentuSp then  error "Brak takiego rekordu"

		IntegrDK = CzyIntegrBrakTypDK(xTypDokumentuSp.symbolFK, xDokumentSp.numer, idDK, sTyp)
	endif
	if IntegrDK then exit

	iSubtyp = xDokumentSp.charakter
	//sprawdzamy czy faktury walutowe nie sa eksportowane jako stare( nie walutowe) do FK
	if(iSubtyp == FVW || iSubtyp == FKW)  && (xTypDokumentuSp.typFK != "FWS" && xTypDokumentuSp.typFK != "FWSK") then
 		if(xDokumentSp.kurs != xDokumentSp.kursDoch) then
			nRes = 1
		else
			nRes = 0
		endif
	endif
	IntegrDK = CzyIntegrBlednyTypFK(nRes, xTypDokumentuSp.symbolFK, xDokumentSp.numer, idDK, sTyp)
	if IntegrDK then exit
	if(xTypDokumentuSp) then
		if(xTypDokumentuSp.typFK == "FVS" || xTypDokumentuSp.typFK == "RUS" || xTypDokumentuSp.typFK == "FVZ" ||xTypDokumentuSp.typFK == "RUZ" || xTypDokumentuSp.typFK == "FVSM" || xTypDokumentuSp.typFK == "FVT") then
		 	czyRelatedDokument = 1
		else
			czyRelatedDokument = 0
		endif
		xDokumentSp.SprawdzUzgodnienieFK()
	endif

	Select Case iSubtyp
		Case FVS, FKS, RUS, RKS, DEX, DXK, PAR, PRK, FAS, FAK, FVW, FKW, FZS, ZKS, WDT, FWS, WKS, WDK, FVT, FTK, REX, RXK, SZA, SZK, SZW, SZWK
			for ii=1 to ii>xDokumentSp.Pozycje.Count()
				if (!xDokumentSp.Pozycje.item(ii).dokompletu && ((!xDokumentSp.CzyKorekta) || (xDokumentSp.CzyKorekta && xDokumentSp.Pozycje.item(ii).wlasna))) then
					if (xDokumentSp.CzyKorekta) then
						if (xDokumentSp.Pozycje.item(ii).idpozkoryg) then
							xRejSp = xDokumentSp.Pozycje.item(ii).przedKorekta.rejestrVAT
							if xRejSp.id then
								if xRejSp.rejestrFKid then
									IntegrDK = CzyintegrBlednyRej(xRejSp.rejestrFKid, xDokumentSp.numer, idDK, 0)
								else
									// nie ma uzgdonionego rejestru
									IntegrDK = CzyintegrBlednyRej(0, xDokumentSp.numer, idDK, 0)
								endif
								if IntegrDK then exit
							else
								// nieokrelony rejestr
								IntegrDK = CzyintegrBrakRej(1, xDokumentSp.numer, idDK)
								if IntegrDK then exit
							endif
						endif

						xRejSp = xDokumentSp.Pozycje.item(ii).poKorekcie.rejestrVAT
						if xRejSp.id then
							if xRejSp.rejestrFKid then
								IntegrDK = CzyintegrBlednyRej(xRejSp.rejestrFKid, xDokumentSp.numer, idDK, 0)
							else
								// nie ma uzgdonionego rejestru
								IntegrDK = CzyintegrBlednyRej(0, xDokumentSp.numer, idDK, 0)
							endif
							if IntegrDK then exit
						else
							// nieokrelony rejestr
							IntegrDK = CzyintegrBrakRej(1, xDokumentSp.numer, idDK)
							if IntegrDK then exit
						endif
					else
						xRejSp = xDokumentSp.Pozycje.item(ii).rejestrVAT
						if xRejSp.id then
							if xRejSp.rejestrFKid then
								IntegrDK = CzyintegrBlednyRej(xRejSp.rejestrFKid, xDokumentSp.numer, idDK, 0)
							else
								// nie ma uzgdonionego rejestru
								IntegrDK = CzyintegrBlednyRej(0, xDokumentSp.numer, idDK, 0)
							endif
							if IntegrDK then exit
						else
							// nieokrelony rejestr
							IntegrDK = CzyintegrBrakRej(1, xDokumentSp.numer, idDK)
							if IntegrDK then exit
						endif
					endif
				endif
			next ii
			If iSubtyp == FVT || iSubtyp == FTK Then
				// faktura turystyczna lub jej korekta - dodatkowo sprawdzamy, czy jest uzgodniony rejestr "NP"
				rsFT.CursorType = 1
				rsFT.LockType = 3
				// odczytujemy ID rejestru NP
				rsFT.Open( ( Using "SELECT TOP 1 RV.rejestr FROM RV JOIN XT ON RV.rejestr = XT.id WHERE RV.dkid = %l AND XT.long2 = 0", idDK ), connFT )
				If rsFT.RecordCount() Then
					rejestrID = rsFT.Fields( "rejestr" ).Value
					xRejSp = GetObjById( "BRejSp", rejestrID )
					If xRejSp Then
						If xRejSp.rejestrFKid Then
							IntegrDK = CzyintegrBlednyRej( xRejSp.rejestrFKid, xDokumentSp.numer, idDK, 0 )
						Else
							IntegrDK = CzyintegrBlednyRej( 0, xDokumentSp.numer, idDK, 0 )
						EndIf
					EndIf
				EndIf
				rsFT.Close()
				If IntegrDK Then Exit
			EndIf
	endselect

	if IntegrDK then exit

	if ( xDokumentSp.czyKorekta ) then bKorekta = 1
		bRozliczony = xDokumentSp.czyRozliczony

		dst.Clear()
		sOpisy=0
		dbd.CurrentDate = sDataWpr
		//sposb wsppracy z FK
		if(xIntegracja.currentLoadNewVersion)then//obiekt integracji obsuguje guidy dokumentw
			dst.Value("UId") = xDokumentSp.guid
		endif

		if iSubtyp == SKO || iSubtyp == SKK || iSubtyp == SKW || iSubtyp == SKWK then
			dst.Value("DataDok") = xDokumentSp.dataRealizacji
			dst.Value("DataOper") = xDokumentSp.dataRealizacji
		else
			dst.Value("DataDok") = xDokumentSp.dataWystawienia
				dst.Value("DataOper") = xDokumentSp.dataSprzedazy
		endif

		dst.Value("Datawpl") = Data()
		dst.Value("Datawpr") = sDataWpr

		if xDokumentSp.danekh.KhId != 0 then
			xKontrahent = GetObjById("BKontrahent", xDokumentSp.danekh.KhId)
			if !xKontrahent then  error "Brak takiego rekordu w bazie KH"

			if ( 1 == xIntegracja.trybWspolpracy || 4 == xIntegracja.trybWspolpracy) then
				dst.Value("kontrahent") = xKontrahent.guid
			else
				dst.Value("kontrahent") = val(xKontrahent.identyfikatorFK)
			endif
		endif

		dst.Danekh.Value("Nazwa") = xDokumentSp.danekh.KhNazwa
		dst.DaneKh.Value("Nip") = xDokumentSp.danekh.KhNIP
		dst.DaneKh.Value("Ulica") = IIF(Len(xDokumentSp.danekh.KhUlica) > lenULICA, Mid(xDokumentSp.danekh.KhUlica,0,lenULICA), xDokumentSp.danekh.KhUlica)
		dst.DaneKh.Value("Dom") = xDokumentSp.danekh.KhDomu
		dst.DaneKh.Value("Lokal") = xDokumentSp.danekh.KhLokal
		dst.DaneKh.Value("Miejscowosc") = IIF(Len(xDokumentSp.danekh.KhMiasto) > lenMIASTO, Mid(xDokumentSp.danekh.KhMiasto,0,lenMIASTO), xDokumentSp.danekh.KhMiasto)
		dst.DaneKh.Value("KodPocztowy") = xDokumentSp.danekh.KhPoczta
		dst.DaneKh.Value("kraj") = xDokumentSp.danekh.kraj.symbol

		if xDokumentSp.danekh.KhKod == "" && xDokumentSp.danekh.KhNazwa != "" then
			kontrah.ClearRecord()
			kontrah.Value("nazwa") = dst.Danekh.Value("Nazwa")
			kontrah.Value("nip") = dst.DaneKh.Value("Nip")
			kontrah.Value("ulica") = dst.DaneKh.Value("Ulica")
			kontrah.Value("nrDomu") = dst.DaneKh.Value("Dom")
			kontrah.Value("nrMieszkania") = dst.DaneKh.Value("Lokal")
			kontrah.Value("miejscowosc") = dst.DaneKh.Value("Miejscowosc")
			kontrah.Value("kodPocztowy") = dst.DaneKh.Value("KodPocztowy")

			IDFK_K = kontrah.CheckIfExists()
			if !IDFK_K then
				if kontrah.Validate() && (IntegrDK == 0) then
					if !kontrah.Insert() && kontrah.CheckIfExists() then
						if ItgInfo.Info("PlanKontSubjectType") then
							dst.Value("kontrahent") = kontrah.GetExistingPoz(0)
						else
							dst.Value("kontrahent") = kontrah.GetExistingId(0)
						endif
					endif
				endif
			else
				if ItgInfo.Info("PlanKontSubjectType") then
					dst.Value("kontrahent") = kontrah.GetExistingPoz(0)
				else
					dst.Value("kontrahent") = kontrah.GetExistingId(0)
				endif
			endif
		endif

		dst.Value("mppFlags") = xDokumentSp.mppFlags

		dst.Value("JPK_V7") = xDokumentSp.JPK_V7

		nWalutowy = 0
		if (iSubtyp != FWS && iSubtyp != WKS && iSubtyp != SKO && iSubtyp != SKK && iSubtyp != SKW && iSubtyp != SKWK && !xDokumentSp.czyKoncowaZerowa ) then
			if !PAF2FK(xDokumentSP) && CzyWalutowy( xDokumentSp.GetRozrachunek().id ) then nWalutowy = 1
		endif

		if nWalutowy then
			dKurs = xDokumentSp.kurs
			dst.Value("kurs") = dKurs
			dst.Value("waluta") = xDokumentSp.waluta

			dKwota = xDokumentSp.wysokoscNaleznosci
			dst.Value("wkwota") = dKwota
			dst.Value("kwota") = Round(dKwota * dKurs, 2)
		else
			dKwota = Round( (xDokumentSp.netto + xDokumentSp.niePodlega + xDokumentSp.vat),2 )
			dst.Value("Kwota") = dKwota
		endif

		sTyp = xDokumentSp.typDk
		if xDokSp.czyZaimport then
			//dokument moze miec typ dokumentu wprowadzony tylko w centrali
			// sprawdzamy czy ma taki typ

			xTypDokumentuSp = GetObjByKod("BTypDokumentuSp", xDokumentSp.typDk)

			sTyp = ""
			if xTypDokumentuSp && (xDokumentSp.charakter == xTypDokumentuSp.charakter) then
				// typ dokumentu pasuje z odzdialu z centrala
				sTyp = xDokumentSp.typDk
			else
				// nie znaleizono typu o takim kodzie wiec
				// szukamy dla podstawowego typu dla charakteru dokumentu
				xTypDokumentuSp = GetObjByKod("BTypDokumentuSp", TypDOK(xDokumentSp.charakter))
				if xTypDokumentuSp && (xDokumentSp.charakter == xTypDokumentuSp.charakter) then
					sTyp = xDokumentSp.typDk
				else
					error "Brak takiego rekordu w bazie DK"
				endif
			endif
		endif
		// w sumie mogloby nie byc tego wraunku bo styp musi byc
			xTypDokumentuSp = GetObjByKod("BTypDokumentuSp", sTyp)
			if !xTypDokumentuSp then  error "Brak takiego rekordu"
		dst.Value("skrot") = xTypDokumentuSp.symbolFK

		if bKorekta then
			if xDokumentSp.czyKZ then	//korekta zbiorcza
				xKZ = xDokumentSp.dokumentyKorygowaneKZ
				k = 1
				for k to k > xKZ.Count
					dst.Powiazanie.Insert()
					dst.Powiazanie.Value("guid") = xKZ.item(k).guid
					dst.Powiazanie.Value("numerDok") = xKZ.item(k).kod
					dst.Powiazanie.Value("dataDok")  = xKZ.item(k).data
					dst.Powiazanie.Value("korekta")  = 0
				next k
			else
				// musimy siegnac do dokumentu korygowanego pierwotnego
				// przyjete ze jest to pierwszy w kolekcji
				if xDokumentSp.DokumentZKorektami.Count() && xDokumentSp.DokumentZKorektami.item(1).Numer!= xDokumentSp.Numer then
					dst.Value("NazwaKor") = xDokumentSp.DokumentZKorektami.item(1).Numer
					dst.Value("DataKor") = xDokumentSp.DokumentZKorektami.item(1).Data
					dst.Powiazanie.Insert()
					dst.Powiazanie.Value("guid") = xDokumentSp.DokumentZKorektami.item(1).guid
					dst.Powiazanie.Value("numerDok") = xDokumentSp.DokumentZKorektami.item(1).Numer
					dst.Powiazanie.Value("dataDok")  = xDokumentSp.DokumentZKorektami.item(1).Data
					dst.Powiazanie.Value("korekta")  = 0
				endif
			endif
		else
			if xDokumentSp.DokumentZKorektami.Count() && xDokumentSp.DokumentZKorektami.item(1).Numer== xDokumentSp.Numer then
				k = 2
				for k to k > xDokumentSp.DokumentZKorektami.Count()
					dst.Powiazanie.Insert()
					dst.Powiazanie.Value("numerDok") = xDokumentSp.DokumentZKorektami.item(k).Numer
					dst.Powiazanie.Value("dataDok")  = xDokumentSp.DokumentZKorektami.item(k).Data
					dst.Powiazanie.Value("korekta")  = 1
				next k
			endif
		endif

		// pozycje dokumentu
		////////////////////////[Pozycja VAT]//////////////////////////

		if nWalutowy && (xTypDokumentuSp.typFK == "FWS" || xTypDokumentuSp.typFK == "FWSK") then //nowy typ dokumentu w FK - wielowalutowy
			dst.RejestrVAT.PozycjaVAT.MoveKursVAT()
			dst.RejestrVAT.PozycjaVAT.Value("TypExt") = 1
			dst.RejestrVAT.PozycjaVAT.Value("Nazwa") = xDokumentSp.waluta
			dst.RejestrVAT.PozycjaVAT.Value("Wartosc") = xDokumentSp.kurs

			dst.RejestrVAT.PozycjaVAT.MoveKursCITPIT()
			dst.RejestrVAT.PozycjaVAT.Value("TypExt") = 2
			dst.RejestrVAT.PozycjaVAT.Value("Nazwa") = xDokumentSp.waluta
			dst.RejestrVAT.PozycjaVAT.Value("Wartosc") = xDokumentSp.kursDoch
		endif

		TabPozVat.ClearRec()
		float wartosc
		dispatch pozycja
		dispatch rejSp
		////////////////////////[Pozycja VAT] - koniec ///////////////
		If iSubtyp != FVT && iSubtyp != FTK Then
		for ii=1 to ii>(xDokumentSp.Pozycje.Count())
			if (!xDokumentSp.Pozycje.item(ii).dokompletu && ((!xDokumentSp.CzyKorekta) || (xDokumentSp.CzyKorekta && xDokumentSp.Pozycje.item(ii).wlasna))) then
				if (xDokumentSp.CzyKorekta) then
					wartosc = 0
					if (xDokumentSp.Pozycje.item(ii).idpozkoryg) then
						pozycja = xDokumentSp.Pozycje.item(ii).przedKorekta
						xRejSp = pozycja.rejestrVAT
						iRejVat = xRejSp.rejestrFKid
						dpStVat = pozycja.stVAT
						TabRejVat.Wstaw(iRejVat,dpStVat, pozycja,1,0, 1, xDokumentSp.SendAggregated)
						//////////////////////////////[Pozycja VAT]///////////////
						wartosc = - (pozycja.niePodlega + pozycja.netto)
					endif

					pozycja = xDokumentSp.Pozycje.item(ii).poKorekcie
					xRejSp = pozycja.rejestrVAT
					iRejVat = xRejSp.rejestrFKid
					dpStVat = pozycja.stVAT
					TabRejVat.Wstaw(iRejVat,dpStVat, pozycja,1,0, 0, xDokumentSp.SendAggregated)
					//////////////////////////////[Pozycja VAT]///////////////
					wartosc = wartosc + (pozycja.niePodlega + pozycja.netto)
					if czyPozycjaVAT then TabPozVat.Wstaw(pozycja, round(wartosc,2), czyDEX)
				else
					pozycja = xDokumentSp.Pozycje.item(ii)
					xRejSp = pozycja.rejestrVAT
					iRejVat = xRejSp.rejestrFKid
					dpStVat = pozycja.stVAT
					TabRejVat.Wstaw(iRejVat,dpStVat, pozycja,1,0, 0, xDokumentSp.SendAggregated)
					//////////////////////////////[Pozycja VAT]///////////////
					if czyPozycjaVAT then
						wartosc = pozycja.niePodlega + pozycja.netto
						TabPozVat.Wstaw(pozycja, round(wartosc,2), czyDEX)
					endif
				endif
				DodajDoOpisu(xDokumentSp.Pozycje.item(ii).opis, "/")
			endif
		next ii
		Else
			sSqlRequest  = " SELECT RV.netto AS RV_netto, RV.vat AS RV_vat, S.id AS S_id, R.id AS R_id, RV.JPK_V7 AS RV_JPK_V7 "
			sSqlRequest += "   FROM HM.RV JOIN HM.XT AS S ON RV.stvat = S.id AND S.typ = 20 JOIN HM.XT AS R ON RV.rejestr = R.id "
			sSqlRequest += "   WHERE RV.dkid = " + ( Using "%l", idDK ) + " "

			xAdoRecordset.Open( sSqlRequest, xAdoConnection )
			If xAdoRecordset.RecordCount() Then
				While !xAdoRecordset.EOF()
					StVatRV = GetObjById( "BStawkaVAT",	xAdoRecordset.Fields( "S_id" ).Value )
					rejSp	= GetObjById( "BRejSp",		xAdoRecordset.Fields( "R_id" ).Value)
					TabRejVat.WstawRV( rejSp.rejestrFKid, xAdoRecordset.Fields( "RV_JPK_V7" ).Value, StVatRV, xAdoRecordset.Fields( "RV_netto" ).Value, xAdoRecordset.Fields( "RV_vat" ).Value )
					xAdoRecordset.MoveNext()
				Wend
			EndIf
			xAdoRecordset.Close()
		EndIf

		If !xDokumentSp.Pozycje.Count() && xDokumentSp.czyKoncowaZerowa Then
			xRejSp = xDokumentSp.rejestrVAT
			iRejVatZFK = xRejSp.rejestrFKid
		EndIf

		dst.Value("nazwa") = xDokumentSp.numer

		xDekretacjeSp.Clear()
		xDekretParams = xDekretacjeSp.Params()
		xDekretParams.id=xDokumentSp.id
		xDekretacjeSp.Dekret(xDekretParams)
		dst.Value("tresc")	= xDekretacjeSp.trescwFK  //opis fk
		if(xTypDokumentuSp.typFK == "FWS" || xTypDokumentuSp.typFK == "FWSK")  then //nowy typ dokumentu w FK - wielowalutowy
			ZapiszZAP(xDekretacjeSp, 0, 0, xDokumentSp.czyRozliczony,xDokumentSp.terminPlatnosci, 0, xDokumentSp.waluta, !czyRelatedDokument, 0)
		else
			ZapiszZAP(xDekretacjeSp, 0, 0, xDokumentSp.czyRozliczony,xDokumentSp.terminPlatnosci, nWalutowy, xDokumentSp.waluta, !czyRelatedDokument, 0)
		endif
		// rwnolege ksigowania magazynowe
		if iOpcje & ROWNOLEGLE_KSIEG_MAG then
			RownolegleKsMg(iOpcje, xDokumentSp, xTypDokumentuSp, bKorekta, nWalutowy, 0, 1, 0)
		endif // rwnolege ksigowania magazynowe

		ZapiszETRANSFERS(xDokumentSp, xDekretacjeSp)

		long lStawka
		float dStawka
		string opis = ""
		// rejestry VAT
		iSubtyp = xDokumentSp.charakter
		If ( iSubtyp == SZA || iSubTyp == SZW ) && xDokumentSp.czyKoncowaZerowa Then
			// zerowa faktura zaliczkowa koncowa
			xConnection = GetAdoConnection()
			xRecordSet = "ADODB.Recordset"

			sRequest  = "SELECT r.kod AS Skrot, r.nazwa AS Nazwa, r.long2 AS Rodzaj, v.wartosc * 100 AS Stawka, CAST( SUBSTRING( d.opis, 1, CHARINDEX( '$$', d.opis ) - 1 ) AS INT ) AS Def "
			sRequest += "  FROM HM.RV "
			sRequest += "       JOIN HM.XT r ON RV.rejestr = r.id "
			sRequest += "	    JOIN HM.XT v ON RV.stvat = v.id "
			sRequest += "	    JOIN HM.NT d ON r.id = d.super AND d.typ = 18 AND d.baza = 2"
			sRequest += " WHERE dkid = "
			sRequest += ( Using "%d", xDokumentSp.id )
			xRecordSet.Open( sRequest, xConnection )
			If xRecordSet.RecordCount() Then
				xTypDok = GetObjByKod( "BTypDokumentuSp" , xDokumentSp.typDk )
				If !xTypDok Then Error "Brak rekordu typu dokumentu"
				While !xRecordSet.EOF()
					If xTypDok.typFK != "DP" Then
					dst.RejestrVAT.Insert()
					If ItgInfo.Info( "VATMP" ) Then
						// VAT naliczony metoda kasowa
						dst.RejestrVAT.Value( "oczek" ) = IIF( ( xDokumentSp.metodaVAT ), DOV_ZAPLATA, DOV_OKRES )
					EndIf
					dst.RejestrVAT.Value( "soczek" ) = dst.RejestrVAT.Value( "oczek" )
					dst.RejestrVAT.Value( "def" ) = xRecordSet.Fields( "Def" ).Value
					dst.RejestrVAT.Value( "typabc" ) = 1
					buf = xDokumentSp.dataRejestrVAT
					strOkres = Find Regular "????????" // osiem pierwszych znakow
					dst.RejestrVAT.Value( "okres" ) = strOkres + "01"
					dst.RejestrVAT.Value( "datadok" ) = xDokumentSp.dataWystawienia
					dst.RejestrVAT.Value( "dataws" ) = xDokumentSp.dataSprzedazy
					dst.RejestrVAT.Value( "stawka" ) = xRecordSet.Fields( "Stawka" ).Value
					dst.RejestrVAT.Value( "brutto" ) = 0
					dst.RejestrVAT.Value( "netto" ) = 0
					dst.RejestrVAT.Value( "vat" ) = 0
					dst.RejestrVAT.Value( "UE" ) = 0
					EndIf
					xRecordSet.MoveNext()
				Wend
			EndIf
			xRecordSet.Close()
		Else
		Select Case iSubtyp
			Case FVS, FKS, RUS, RKS, PAR, PRK, FAS, FAK, FVW, FKW, FZS, ZKS, WDT, FWS, WKS, WDK, FVT, FTK, REX, RXK, SZA, SZK, SZW, SZWK

				xTypDok = GetObjByKod( "BTypDokumentuSp" , xDokumentSp.typDk )
				If !xTypDok Then Error "Brak rekordu typu dokumentu"
				for iPom=1 to iPom>TabRejVat.IloscRejestrow(0)
					for iPomStVat=1 to iPomStVat>TabRejVat.IloscStawek(iPom)
						If xTypDok.typFK != "DP" Then
						dst.RejestrVAT.Insert()
						if ItgInfo.Info("VATMP") then
							// VAT naliczony metoda kasowa
							dst.RejestrVAT.Value("oczek") = iif((xDokumentSp.metodaVAT),DOV_ZAPLATA,DOV_OKRES)
						endif

						dst.RejestrVAT.Value("soczek") = dst.RejestrVAT.Value("oczek")

						dst.RejestrVAT.Value("def") = IIF( iRejVatZFK, iRejVatZFK, TabRejVat.RejVat(iPom).id )
						dst.RejestrVAT.Value("typabc") = 1
						dst.RejestrVAT.Value("JPK_V7") = IIF(!xDokumentSp.SendAggregated, TabRejVat.RejVat(iPom).JPK_V7, AggregatedGTU())
						buf = xDokumentSp.dataRejestrVAT
						strOkres = Find Regular "????????" // osiem pierwszych znakw
						dst.RejestrVAT.Value("okres") = strOkres + "01"
						dst.RejestrVAT.Value("datadok") = xDokumentSp.dataWystawienia
						dst.RejestrVAT.Value("dataws") = xDokumentSp.dataSprzedazy
						dst.RejestrVAT.Value("stawka") = TabRejVat.Wartosc(iPom, iPomStVat, "stawka")
						dst.RejestrVAT.Value("brutto") = Round( (TabRejVat.Wartosc(iPom, iPomStVat, "netto") + TabRejVat.Wartosc(iPom, iPomStVat, "vat")),2 )
						dst.RejestrVAT.Value("netto") = Round( TabRejVat.Wartosc(iPom, iPomStVat, "netto"),2 )
						dst.RejestrVAT.Value("vat") = Round( TabRejVat.Wartosc(iPom, iPomStVat, "vat"),2 )
						
						if (iSubtyp == FVS || iSubtyp == FKS || iSubtyp == FVW || iSubtyp == FKW) then
							buf=xDokumentSp.daneod.KhNIP
							if(xDokumentSp.daneod.KhNIP == "" || find "P:") then
								dst.RejestrVAT.Value("KrajKod") = xDokumentSp.daneod.kraj.symbol
							endif
						endif

						if(nWalutowy &&(xTypDokumentuSp.typFK == "FWS" || xTypDokumentuSp.typFK == "FWSK"))  then //nowy typ dokumentu w FK - wielowalutowy
							dst.RejestrVAT.Value("bruttoWaluta") = Round(TabRejVat.Wartosc(iPom, iPomStVat, "wbrutto"),2)
							dst.RejestrVAT.Value("nettoWaluta") = Round( TabRejVat.Wartosc(iPom, iPomStVat, "wnetto"),2)
							dst.RejestrVAT.Value("vatWaluta") = Round((TabRejVat.Wartosc(iPom, iPomStVat, "wbrutto") - TabRejVat.Wartosc(iPom, iPomStVat, "wnetto")),2)
						endif
						dst.RejestrVAT.Value("UE") = 0
						EndIf
					next iPomStVat
					//////////////////////////////[Pozycja VAT]///////////////
					if (czyPozycjaVAT) then
						for iPos=1 to iPos > TabPozVat.Rozmiar()
							if TabPozVat.PozVat(iPos).rejestrVat == TabRejVat.RejVat(iPom).id && TabPozVat.PozVat(iPos).JPK_V7 == TabRejVat.RejVat(iPom).JPK_V7 then
								dst.RejestrVAT.PozycjaVAT.Insert()
								lStawka = TabPozVat.PozVat(iPos).stawka
								dStawka = TabPozVat.StVat(TabPozVat.ZnajdzStawke(lStawka)).stawka
								dst.RejestrVAT.PozycjaVAT.Value("Stawka") = dStawka
								//towar
								if TabPozVat.PozVat(iPos).towar != "" then
									if (xTowar = GetObjByKod("BTowar", TabPozVat.PozVat(iPos).towar)) then
										opis = xTowar.nazwa
										lStawka = TabPozVat.StVat(TabPozVat.InitStawke(xTowar.stVAT)).id
										dStawka = TabPozVat.StVat(TabPozVat.ZnajdzStawke(lStawka)).stawka
									endif
								else
									opis = TabPozVat.PozVat(iPos).opis
								endif

								opis = NormalizeString(opis, lOPIS)

								dst.RejestrVAT.PozycjaVAT.Value("Stawka_pl") = dStawka
								dst.RejestrVAT.PozycjaVAT.Value("Nazwa") = opis
								dst.RejestrVAT.PozycjaVAT.Value("Wartosc") = TabPozVat.PozVat(iPos).wartosc
								dst.RejestrVAT.PozycjaVAT.Value("Usluga") = TabPozVat.PozVat(iPos).usluga
								dst.RejestrVAT.PozycjaVAT.Value("UE") = TabPozVat.PozVat(iPos).UE														
							endif
						next iPos
					endif
				next iPom

			Case DEX, DXK

				xTypDok = GetObjByKod( "BTypDokumentuSp" , xDokumentSp.typDk )
				If !xTypDok Then Error "Brak rekordu typu dokumentu"
				for iPom=1 to iPom>TabRejVat.IloscRejestrow(0)
					for iPomStVat=1 to iPomStVat>TabRejVat.IloscStawek(iPom)
						If xTypDok.typFK != "DP" Then
						dst.RejestrVAT.Insert()
						if ItgInfo.Info("VATMP") then
							// VAT naliczony metoda kasowa
							dst.RejestrVAT.Value("oczek") = iif((xDokumentSp.metodaVAT),DOV_ZAPLATA,DOV_OKRES)
						endif

						dst.RejestrVAT.Value("def") = TabRejVat.RejVat(iPom).id
						dst.RejestrVAT.Value("typabc") = 1
						dst.RejestrVAT.Value("JPK_V7") = TabRejVat.RejVat(iPom).JPK_V7
						buf = xDokumentSp.dataRejestrVAT
						strOkres = Find Regular "????????" // osiem pierwszych znakw
						dst.RejestrVAT.Value("okres") = strOkres + "01"
						dst.RejestrVAT.Value("datadok") = xDokumentSp.dataWystawienia
						dst.RejestrVAT.Value("dataws") = xDokumentSp.dataSprzedazy

						dst.RejestrVAT.Value("stawka") = TabRejVat.Wartosc(iPom, iPomStVat, "stawka")
						if dst.RejestrVAT.Value("stawka") != -2 then
							dst.RejestrVAT.Value("stawka") = 0
						endif
						dst.RejestrVAT.Value("brutto") = Round( (TabRejVat.Wartosc(iPom, iPomStVat, "netto") + TabRejVat.Wartosc(iPom, iPomStVat, "vat")),2 )
						dst.RejestrVAT.Value("netto") = Round( TabRejVat.Wartosc(iPom, iPomStVat, "netto"),2 )
						dst.RejestrVAT.Value("vat") = Round( TabRejVat.Wartosc(iPom, iPomStVat, "vat"),2 )
						dst.RejestrVAT.Value("UE") = 0						
						EndIf
					next iPomStVat
					//////////////////////////////[Pozycja VAT]///////////////
					if (czyPozycjaVAT) then
						for iPos=1 to iPos > TabPozVat.Rozmiar()
							if TabPozVat.PozVat(iPos).rejestrVat == TabRejVat.RejVat(iPom).id && TabPozVat.PozVat(iPos).JPK_V7 == TabRejVat.RejVat(iPom).JPK_V7 then
								dst.RejestrVAT.PozycjaVAT.Insert()
								lStawka = TabPozVat.PozVat(iPos).stawka
								dStawka = TabPozVat.StVat(TabPozVat.ZnajdzStawke(lStawka)).stawka
								dst.RejestrVAT.PozycjaVAT.Value("Stawka") = dStawka
								//towar
								if TabPozVat.PozVat(iPos).towar != "" then
									if (xTowar = GetObjByKod("BTowar", TabPozVat.PozVat(iPos).towar)) then
										opis = xTowar.nazwa
										lStawka = TabPozVat.StVat(TabPozVat.InitStawke(xTowar.stVAT)).id
										dStawka = TabPozVat.StVat(TabPozVat.ZnajdzStawke(lStawka)).stawka
									endif
								else
									opis = TabPozVat.PozVat(iPos).opis
								endif

								opis = NormalizeString(opis, lOPIS)

								dst.RejestrVAT.PozycjaVAT.Value("Stawka_pl") = dStawka
								dst.RejestrVAT.PozycjaVAT.Value("Nazwa") = opis
								dst.RejestrVAT.PozycjaVAT.Value("Wartosc") = TabPozVat.PozVat(iPos).wartosc
								dst.RejestrVAT.PozycjaVAT.Value("Usluga") = TabPozVat.PozVat(iPos).usluga
								dst.RejestrVAT.PozycjaVAT.Value("UE") = TabPozVat.PozVat(iPos).UE
							endif
						next iPos
					endif
				next iPom
		EndSelect
		EndIf // If "zerowa faktura zaliczkowa koncowa" Then ... Else ... EndIf

		TabRejVat.IloscRejestrow(-1)
		TabRejVat.ClearRec()

		if (xTypDokumentuSp.typFK == "FWS" || xTypDokumentuSp.typFK == "FWSK") then //nie tylko dla faktury w walucie
			dst.Value("waluta") = ""
			dKurs = 0
			dst.Value("kurs") = dKurs
			dst.Value("wkwota") = dKurs
		endif

		if (xIntegracja.CzyItgXML == 1 && xDokumentSp.statusRDF) then
			dst.ValidateForXML()
		else
			dst.Validate()
		endif
		if (ers.Count) then IntegrDK = ShowError( xDokumentSp.nazwa+" "+xDokumentSp.numer)

		if(IntegrDK == 0) then
			if (xIntegracja.CzyItgXML == 1 && xDokumentSp.statusRDF) then
				xmlDoc = dst.GiveXML(0)
				xParams = xfactory.NewObject("BDekretacjeXml")
				xParams.guid = xDokumentSp.guid
				xparams.tresc = xmlDoc
				xIntegracja.ZapiszXMLwRDF(xParams)
			EndIf

			If ( xIntegracja.CzyItgXML != 1 || !xDokumentSp.statusRDF ) Then
				IntegrDK = !dst.Insert()
				if (IntegrDK == 0 && xIntegracja.trybWspolpracy == 4) then
					xIntegracja.UstawDokumentRDFwBuforzeFK(xDokumentSp) // tylko dla wsplnej bazy ustawiamy status dokumentu w RDF
				endif
			EndIf
		endif
		ShowStatus(xDokumentSp.numer,idDK, IntegrDK)
EndSub

// ==============================          ZBIORCZE          ==============================

Int Sub IntegrDK_zb_begin()

	dWartoscDok = 0
	terminplat = ""
	bPierwszyDokument = 1
	sOpisy = 0
	nLastZap = 0

EndSub

Int Sub IntegrDK_zb_do( Long idDK, Int iOpcje )

	IntegrDK_zb_do = 1

	Dispatch xDokSp, xKsSchematSp, xTypDokumentuSp
	Float    dWartosc
	Int      iDodajDekret, iRok
	String   sTyp

	If !( xDokumentSp = GetObjById( "BDokumentSp", idDK ) ) Then Error "Brak dokumentu w bazie DK"

	iRok = dbd.firmainfo.GetRokByDate( xDokumentSp.dataWystawienia )
	If RokFK( 1 ).Zap == 1 Then
		If RokFK( 1 ).IdRok != iRok Then
			UstawRok( iRok )
		EndIf
	Else
		UstawRok( iRok )
	EndIf

	dst = RokFK( 1 ).Rok
	plkn = RokFK( 1 ).PlanKont
	defdok = RokFK( 1 ).DefDokument

	// pomijamy dokumenty, ktore nie moga byc wyslane zbiorczo
	If !xDokumentSp.SendAggregated Then Exit

	If CzyIntegrBrakSchematu( xDokumentSp.schematKsiegowania, xDokumentSp.numer, idDK ) Then Exit

	xKsSchematSp = GetObjByKod( "BKsSchematSp", xDokumentSp.schematKsiegowania )
	If xKsSchematSp Then
		nRes = 0
	Else
		nRes = 1
	EndIf

	If CzyIntegrBlednySchemat( nRes, xDokumentSp.numer, idDK ) Then Exit

	// ========================================          TO DO          ========================================
	//
	// If IntegrZatwWart( xDokumentSp, "" ) Then Exit
	//
	// ========================================          TO DO          ========================================

	IntegrDK_zb_do = 0

	dWartosc = xDokumentSp.wartosc
	dWartoscDok += dWartosc

	If bPierwszyDokument Then
		bPierwszyDokument = 0
		iDodajDekret = 0
		dst.Clear()
		sTyp = xDokumentSp.typDk

		if !( xDokSp = GetObjById( "BDokSp", idDK ) ) Then Error "Brak dokumentu w bazie DK"

		If xDokSp.czyZaimport Then
			//dokument moze miec typ dokumentu wprowadzony tylko w centrali
			xTypDokumentuSp = GetObjByKod( "BTypDokumentuSp", xDokumentSp.typDk )
			sTyp = ""
			If xTypDokumentuSp && ( xDokumentSp.charakter == xTypDokumentuSp.charakter ) Then
				// zgodny typ dokumentu odzial / centrala
				sTyp = xDokumentSp.typDk
			Else
				// nie znaleizono typu o takim kodzie wiec
				// szukamy dla podstawowego typu dla charakteru dokumentu
				xTypDokumentuSp = GetObjByKod( "BTypDokumentuSp", TypDOK( xDokumentSp.charakter ) )
				If xDokumentSp.charakter == xTypDokumentuSp.charakter Then
					sTyp = xDokumentSp.typDk
				Else
					Error "Brak typu dokumentu w bazie"
				EndIf
			EndIf
		EndIf
		If !( xDokSp.czyZaimport ) || ( ( xDokSp.czyZaimport ) && sTyp != "" ) Then
			xTypDokumentuSp = GetObjByKod( "BTypDokumentuSp", sTyp )
			If !xTypDokumentuSp Then Error "Brak typu dokumentu w bazie"
		EndIf

		dst.Value( "skrot" ) = xTypDokumentuSp.symbolFK
		dbd.CurrentDate = sDataWpr
		dst.Value( "DataDok" ) = xDokumentSp.dataWystawienia
		dst.Value( "DataOper" ) = xDokumentSp.dataSprzedazy
		dataRejestrVATzbiorczy = xDokumentSp.dataRejestrVAT
		dst.Value( "Datawpl" ) = Data()
		dst.Value( "Datawpr" ) = sDataWpr
		If terminplat > xDokumentSp.terminPlatnosci Then terminplat = xDokumentSp.terminPlatnosci
		dst.Value( "nazwa" ) = "Dokument zbiorczy"
		zbiorczaTresc = ""
		dst.Value( "JPK_V7" ) = AggregatedJPK_V7()
		xDekretacjeSp.Clear()
	Else
		iDodajDekret = 1
	EndIf

	xDekretParams = xDekretacjeSp.Params()
	xDekretParams.id = xDokumentSp.id
	xDekretParams.Dodaj = iDodajDekret //(iOpcje & DEKRETY_ZBIORCZE)
	xDekretacjeSp.Dekret( xDekretParams )
	If zbiorczaTresc == "" Then
		zbiorczaTresc = xDekretacjeSp.trescwFK
		dst.Value( "tresc" ) = zbiorczaTresc
	EndIf

EndSub

Int Sub IntegrDK_zb_end( Int iOpcje )

	Dispatch xIntegracja = xFactory.GetObject("BIntegracjaFK")
	Dispatch xParams
	String   xmldoc

	Int stop = 0

	If iOpcje & DEKRETY_ZBIORCZE Then
		xDekretacjeSp.Optymalizuj()
	EndIf

	If iDokumentZbiorczy Then
		ZapiszZAP( xDekretacjeSp, 0, 0, 0, terminplat, 0, "", 0, 0 )
	EndIf

	// rownolegle ksiegowania magazynowe
	Int      index = 1
	Dispatch xDokumentSp, xTypDokumentuSp

	If iRownoKsiegMag && (Size( listaDokId ) > 1) Then
		While index < Size( listaDokId )
			If !( xDokumentSp = GetNewObjById( "BDokumentSp", listaDokId( index ).lDokId ) ) Then Error "Bd podczas odczytywania dokumentu"
			If !( xTypDokumentuSp = GetObjByKod( "BTypDokumentuSp", xDokumentSp.typDK ) ) Then Error "Bd podczas odczytywania typu dokumentu"

			If !xDokumentSp.czyAnulowany Then
				// dokumenty anulowane recznie i faktura bez wydan
				RownolegleKsMg( iOpcje, xDokumentSp, xTypDokumentuSp, xDokumentSp.CzyKorekta, 0, IIF(iDekretyZbiorcze && (index>1), 1, 0), IIF(!iDekretyZbiorcze || (index+1==Size(listaDokId)), 1, 0),iDekretyZbiorcze)
			EndIf

			index += 1
		Wend
	EndIf

	// rejestry
	Dispatch dpStVat, pozycja, xRejSp
	Int      ii, iPom, iPomStVat, iRejVat, iSubtyp
	String   strOkres

	// przygotowanie informacji o rejestrach
	index = 1
	While index < Size( listaDokId )
		If !( xDokumentSp = GetObjById( "BDokumentSp", listaDokId( index ).lDokId ) ) Then Error "Bd podczas odczytywania dokumentu"
		If !( xTypDok = GetObjByKod( "BTypDokumentuSp" , xDokumentSp.typDk ) ) Then Error "Bd podczas odczytywania typu dokumentu"

		iSubtyp = xDokumentSp.charakter

		If xTypDok.typFK != "DP" Then
			For ii=1 To ii>xDokumentSp.Pozycje.Count()
				If (!xDokumentSp.Pozycje.item(ii).dokompletu && ((!xDokumentSp.CzyKorekta) || (xDokumentSp.CzyKorekta && xDokumentSp.Pozycje.item(ii).wlasna))) Then
					If (xDokumentSp.CzyKorekta) Then
						If xDokumentSp.Pozycje.item(ii).idpozkoryg Then
							pozycja = xDokumentSp.Pozycje.item(ii).przedKorekta
							xRejSp = pozycja.rejestrVAT
							iRejVat = xRejSp.rejestrFKid
							dpStVat = pozycja.stVAT
							If CzyintegrBlednyRej(xRejSp.rejestrFKid, xDokumentSp.numer, xDokumentSp.id, 1) Then stop = 1 : Exit
							TabRejVat.Wstaw(iRejVat, dpStVat, pozycja, 1, 0, 1, xDokumentSp.SendAggregated)
						EndIf

						pozycja = xDokumentSp.Pozycje.item(ii).poKorekcie
						xRejSp = pozycja.rejestrVAT
						iRejVat = xRejSp.rejestrFKid
						dpStVat = pozycja.stVAT
						If CzyintegrBlednyRej(xRejSp.rejestrFKid, xDokumentSp.numer, xDokumentSp.id, 1) Then stop = 1 : Exit
						TabRejVat.Wstaw(iRejVat, dpStVat, pozycja, 1, 0, 0, xDokumentSp.SendAggregated)
					Else
						pozycja = xDokumentSp.Pozycje.item(ii)
						xRejSp = pozycja.rejestrVAT
						iRejVat = xRejSp.rejestrFKid
						dpStVat = pozycja.stVAT
						If CzyintegrBlednyRej(xRejSp.rejestrFKid, xDokumentSp.numer, xDokumentSp.id, 1) Then stop = 1 : Exit
						TabRejVat.Wstaw(iRejVat, dpStVat, pozycja, 1, 0, 0, xDokumentSp.SendAggregated)
					EndIf
				EndIf
			Next ii
		EndIf

		index += 1
	Wend

	If stop Then Exit

	// zapis informacji o rejestrach
	For iPom=1 To iPom>TabRejVat.IloscRejestrow(0)
		For iPomStVat=1 To iPomStVat>TabRejVat.IloscStawek(iPom)
			dst.RejestrVAT.Insert()
			dst.RejestrVAT.Value("soczek") = dst.RejestrVAT.Value("oczek")
			dst.RejestrVAT.Value("def") = TabRejVat.RejVat(iPom).id
			dst.RejestrVAT.Value("typabc") = 1
			dst.RejestrVAT.Value("JPK_V7") = AggregatedGTU()
			buf = dataRejestrVATzbiorczy
			strOkres = Find Regular "????????" // osiem pierwszych znakw
			dst.RejestrVAT.Value("okres") = strOkres + "01"
			dst.RejestrVAT.Value("datadok") = dst.Value( "DataDok" )
			dst.RejestrVAT.Value("dataws") = dst.Value( "DataOper" )
			dst.RejestrVAT.Value("stawka") = TabRejVat.Wartosc(iPom, iPomStVat, "stawka")
			dst.RejestrVAT.Value("brutto") = Round( (TabRejVat.Wartosc(iPom, iPomStVat, "netto") + TabRejVat.Wartosc(iPom, iPomStVat, "vat")),2 )
			dst.RejestrVAT.Value("netto") = Round( TabRejVat.Wartosc(iPom, iPomStVat, "netto"),2 )
			dst.RejestrVAT.Value("vat") = Round( TabRejVat.Wartosc(iPom, iPomStVat, "vat"),2 )
			dst.RejestrVAT.Value("UE") = 0
			
			if (iSubtyp == FVS || iSubtyp == FKS || iSubtyp == FVW || iSubtyp == FKW) then
				buf=xDokumentSp.daneod.KhNIP
				if(xDokumentSp.daneod.KhNIP == "" || find "P:") then
					dst.RejestrVAT.Value("KrajKod") = xDokumentSp.daneod.kraj.symbol
				endif
			endif
		Next iPomStVat
	Next iPom

	TabRejVat.IloscRejestrow(-1)
	TabRejVat.ClearRec()

	If dst Then
		dst.Value( "kwota" ) = Round( dWartoscDok )
		dst.Validate()
	EndIf

	If ers.Count Then
		IntegrDK_zb_end = ShowError( "Dokument zbiorczy" )
	EndIf

	If dst Then
		If !IntegrDK_zb_end Then
			IntegrDK_zb_end = !dst.Insert()
		EndIf

		dst.Clear()
	EndIf

	ShowStatus( "Dokument zbiorczy", 0, IntegrDK_zb_end )

EndSub

// ==============================          ZBIORCZE          ==============================

int Sub BeginProcessDK()

	TabRejVat.ClearRec()

	If iDokumentZbiorczy Then
		Shrink listaDokId, -1
		IntegrDK_zb_begin()
	EndIf

EndSub


int Sub DoProcessDK(long idDK)
	DoProcessDK = 0
	rozUidStrona = ROZ_STRONA_WN
	int iVal, err
	int iOpcje = 0
	long ii
	Dispatch xDokSp
	Dispatch xDokMg

	// paragony wysylane zbiorczo do FK ---> dwukrotny przebieg integracji
	// KONIECZNE odczytanie aktualnego ustawienia parametru zmienianego czasowo z poziomu C++
	iDokumentZbiorczy = Val( GetIni ( "Integracja z FK dokumentw sprzeday", "Dokument zbiorczy" ) )

	nRes=!(xDokumentSp=GetObjById("BDokumentSp",idDK))
	if nRes then  Error "Brak takiego rekordu w bazie DK"


	nRes=!(xDokSp=GetObjById("BDokSp",idDK))
	if nRes then  error "Dokument nie zaadowany"

	if ( xDokSp.czyBufor ) then
		DoProcessDK = 1 // pomijamy
		AddUniqueError("Nie mona wysa niezatwierdzonego dokumentu " + xDokumentSp.numer+".",idDK)
		Exit // nie wysyamy dokumentw z bufora
	endif

	if ( xDokSp.czyAnulowany ) then
		// dopuszczamy paragon anulowany po wystawieniu do niego faktury
		If (PAF2FK(xDokumentSp)) Then
			If !( iNieIntegrOznak && xDokSp.czyWyekspFK ) Then AddWarning( xDokumentSp.numer + " Anulowany paragon zostanie wysany do FK.", idDK )
		Else
			DoProcessDK = 1 // pomijamy
			AddUniqueError("Nie mona wysa anulowanego dokumentu " + xDokumentSp.numer+".",idDK)
			Exit // nie wysyamy dokumentw anulowanych
		EndIf
	endif

	if (xDokumentSp.charakter == SKO || xDokumentSp.charakter == SKK || xDokumentSp.charakter == SKW || xDokumentSp.charakter == SKWK) && (xDokumentSp.dataRealizacji == "")then
		DoProcessDK = 1 // pomijamy
		AddUniqueError("Nie mona wysa kontraktu z nieokrelon dat realizacji " + xDokumentSp.numer+".",idDK)
		Exit //nie wysyamy kontraktw bez okrelonej daty realizacji
	endif

	if ( iNieIntegrOznak && xDokSp.czyWyekspFK ) then
		DoProcessDK = 1 // pomijamy
		AddUniqueError("Nie mona powtrnie wysa dokumentu " + xDokumentSp.numer+".",idDK)
		Exit // nie wysyamy oznakowanych dokumentw
	endif

	// czy rwnolege ksigowanie magazynowe
	if ( iRownoKsiegMag ) then iOpcje |= ROWNOLEGLE_KSIEG_MAG

	if ( iNieIntegrOznak ) then iOpcje |= NIE_EKSP_OZNAK

	If iDokumentZbiorczy Then
		If iDekretyZbiorcze Then
			iOpcje |= DEKRETY_ZBIORCZE
		EndIf

		If IntegrDK_zb_do( idDK, iOpcje ) Then
			DoProcessDK = 1
			Exit
		EndIf

		listaDokId( Size( listaDokId ) ).lDokId = idDK
		Grow listaDokId, 1
	Else
		TabRejVat.ClearRec()
		DoProcessDK = IntegrDK( idDK, iOpcje )
		If DoProcessDK Then Exit
	EndIf

	/////////////////////////////////////////////////
	// oznaczamy wysane dokumenty
	if ( iOznaczaj ) then
		OznaczajEkspFK( idDK )
	endif
EndSub

int Sub EndProcessDK()

	Int      iOpcje = 0
	Int      index = 1
	Dispatch xDokSp

	If iDokumentZbiorczy && Size( listaDokId ) > 1 Then
		If iDekretyZbiorcze Then
			iOpcje |= DEKRETY_ZBIORCZE
		EndIf

		If !IntegrDK_zb_end( iOpcje ) && iOznaczaj Then
			While index < Size( listaDokId )
				OznaczajEkspFK( listaDokId( index ).lDokId )
				index += 1
			Wend
		EndIf
	EndIf

	Shrink listaDokId, -1

EndSub
