//"koreng.sci","Engine do dokumentw korygujcych","\Dokumenty\Sprzeda\",0,2.1.12,SYSTEM
///////////////////////////////////////////
//Engine do dokumentw korygujcych
//koreng.sci
//////////////////////////////////
#define APOSTROF "\t"
#define KOREKTY
#define FKS 41
#define RKS 43
#define DXK 45
#define PRK 51
#define FKZ 69
#define RKZ 71
#define DKM 73
#define FAK 80
#define FKR 100
#define FKW 102
#define FKM	107
#define ZKS 112//korekta zaliczki
#define ZKZ 113//korekta zaliczki (zakup)
#define WKS 118
#define WKZ 119
#define WDK 120
#define WNK 121
#define ZSK 122
#define ZZK 123
#define KRW	127//rachunek w walucie korekta
#define FWS 116
#define WKS 118
#define SKK 135
#define SZK 137
#define ZWK 139
#define SKWK 151
#define SZWK 153
#define FTK 125		// Faktura marza korekta

Limit 32000
MapValue mPozOpis
mPozOpis.Clear()
mPozOpis.Type(string)

#ifdef PNABYWCE then
	int DokZakupu = 1
	#define ZAKUP
#else
	int DokZakupu = 0
#endif

Float ftkIlosc
Float ftkWartoscBrutto
Int   ftkPos
Int   ftkStop

Float ftkPrzedRAZEM		// razem przed i po bez uwzgledniania korekty stawki VAT
Float ftkPoRAZEM

string xBazaDok
#ifdef ZAKUP
	xBazaDok="Zk"
#else
	xBazaDok="Sp"
#endif
#ifdef KONTRAKTZ
	xBazaDok="Zw"
#endif
#ifdef KONTRAKTS
	xBazaDok="Zo"
#endif
#ifdef KONTRAKTKOR
	xBazaDok="Sp"
#endif
//---------------------------------------------------------------------------------------------------------------
record rWyd
	string		Nazwa[41]
	string		Data_Wyd[11]
endrec
int bRW
int bNotatkaKh
Record InfoPoz
	int	   	lp
	int 	lpsuper
	long	superkoryg
	int		iOO
	string 	Opis[100]
	int		nKorStat //kVat - 1, kIlosc - 2, kCena - 3
	string	KorTytul[30]
	string  Kod[41]
	string  KodObcy[41]
	string 	SWW[21]
	String  GTU[11]
	Int     flagi
	float 	PrzelJMDod
	float 	Ilosc
	float 	IloscWP
	string 	Jm[9]
	string 	JmWP[9]
	float	Cena
	Float	CenaWP
	float 	CenaNetto
	float 	CenaBrutto
	float	NiePodlega
	float   WartoscNetto
	float   WartoscBrutto
	string	stVAT[5]
	int		czyNPo
	float 	KwotaVat
	float	clo
	float	akcyza
	float	Rabaty //rabaty pozycji
	float	bruttoWal
	float	nettoWal

	int sub ClearPoz()
		lp=nKorStat=lpsuper=0
		StVat=opis=KorTytul=Kod=KodObcy=SWW=Jm=JmWP=""
		czyNPo=0
		PrzelJmDod=Ilosc=IloscWP=NiePodlega=CenaNetto=CenaBrutto=WartoscNetto=WartoscBrutto=0
		Cena=CenaWP=KwotaVat=clo=akcyza=Rabaty=nettoWal=bruttoWal=0
		superkoryg=0
	endsub
EndRec

record rStawki
	float	Netto
	string	Nazwa[10]
	float	Vat
	float	Brutto
	string  Opis[100]
	Float	NettoWal
	Float	BruttoWal
endrec

record InfoDost
	int  lp
	float cena
	int   typ		// 1-pozycja przed korekt 2-korekta 3-po korekcie
	string nazwa[101]
	float ilosc
	float wartosc
	long  iddokkoryg
	Float iloscAkt
endrec

record InfoPlatWal
	int id
	string waluta[6]
	string wartoscDK[30]
	string wartoscRL[30]
endrec

InfoPlatWal rplatwal(1)
int sub AddPlatWal(string waluta, float wartDK, float wartRL)
	int id
	if id=rplatwal(Size(rplatwal)).id then grow rplatwal,1
	id+=1
	rplatwal(id).id=id
	rplatwal(id).waluta=IIF(waluta!="", waluta, "PLN")
	rplatwal(id).wartoscDK=Kwota(wartDK)
	rplatwal(id).wartoscRL=Kwota(wartRL)
endsub
int sub ClearPlatWal()
	shrink rplatwal,-1
	rplatwal(1).id=0
endsub

InfoDost Dostawy(1)
rStawki StPrzed(1)
rStawki StKorekta(1)
rStawki StPo(1)
rStawki StDokKor(1)	//korekty zbiorcze - korygowane pozycje dokumentu w stawkach
rWyd Wydania(1)
InfoPoz korekty(1)
InfoPoz Przed(1)
InfoPoz	Po(1)
InfoPoz Tmp
InfoPoz korektyNP(1)
InfoPoz przedNP(1)
InfoPoz poNP(1)

MapValue mDst
mDst.Clear()
mDst.Type(int)

Int DostawyKorygowane = 0
int warPodlega ,warNiepodlega 
int GRAF = !Val ( Arg0 )
int BUFOR = Val ( Arg2 )
long idDokKoryg = val(arg1)
long xDocType
int czyKursWaluty//dla korekt faktur wewnetrznych
int czyPozPodlega
dispatch xMag,xPow
int wyjdz=0,wydlabel=0
int CzyRozrWal
if !idDokKoryg then message "Raport mona wykona tylko z okna dokumentu" : Error ""
//potrzebne do dostaw

int nResult,xInd
string MiejsceWyst
string sStndError
#include "Wydruki - include"
//---------------------------------------------------------------------------------------------------------------
int sub XErr(int nErr)
int i
	if nErr==771 then
		for i=1 to i>xFactory.komunikaty.count
			if xFactory.komunikaty.item(i).status then
				sStndError+= "Bd nr."+(using "%d",xFactory.komunikaty.item(i).id)+": '"+xFactory.komunikaty.item(i).tresc+"'\n"//Atrybut: "+xFactory.komunikaty.item(i).nazwapola+"\n"
			else
				sStndError+="OSTRZEENIE !! "+xFactory.komunikaty.item(i).tresc+"\n"
			endif
		next i
	else
		Select case nErr
			case -4101
				sStndError = "Nie odnaleziono rekordu w bazie XT"
			case -4010
				sStndError = "Nieunikalny kod towaru."
			case -4013
				sStndError = "Nie podano nazwy obiektu."
			case 4
				sStndError = "Nie odnaleziono obiektu."
			case -4201
				sStndError = "Nie mona zapisac obiektu, w bazie danych istnieje ju obiekt posiadajcy ten sam skrot i charakter."
			case else
				sStndError = "Nieznany bd nr. "+(using "%d",nErr)
		endselect
	endif
endsub

//------------------------------------------------------------------------------------------------------------


//#############################################################################################################
//Mapy i ich obsuga do powizania pozycji magazynowych z handlowymi

MapValue mIdDokKoryg
mIdDokKoryg.Type(long)

MapValue mIdDocNewPos			// dokumenty korekt z nowymi pozycjami
mIdDocNewPos.Type(Long)

MapValue mIdPosKoryg
mIdPosKoryg.Type(long)

MapValue mIdPozMgToIdHn
mIdPozMgToIdHn.Type(long)

MapValue mIdPozMgToLpHn
mIdPozMgToLpHn.Type(int)

int Sub ReadPosConnection()
//funkcja odczytuje powizania pozycji dokumentw magazynowych z handlowymi
//parametry:
//in
//mIdDokKoryg - mapa dokumentw handlowych ktrych powiza szukamy
//mIdPosKoryg - mapa pozycji z dokumentw handlowych ktrych powiza szukamy, jeli pusta to czytamy wszystkie pozycje z dokument

//out
//mIdPozMgToIdHn - mapa pozycji magazynowych i odpowiadajcych im pozycji handlowych (id)
//mIdPozMgToLpHn - mapa pozycji magazynowych i odpowiadajcych im pozycji handlowych (lp)

	dispatch xDk, xPoz, xRoz, xOper
	int iDokIdx
	int i, j

	mIdPozMgToIdHn.Clear()
	mIdPozMgToLpHn.Clear()

	for iDokIdx = 1 to iDokIdx > mIdDokKoryg.size()	

		xDk = GetObjById("BDokument"+xBazaDok, val(mIdDokKoryg.GetKey(iDokIdx)))

		for i = 1 to i > xDk.Pozycje.count
		
			xPoz = xDk.Pozycje.item(i)//.PoKorekcie //PrzedKorekta	//
		
			if mIdPosKoryg.size() == 0 || mIdPosKoryg.Index(using "%l", xPoz.id) then
				xRoz = xPoz.Operacja.RozliczeniaTw
				mIdPozMgToLpHn.Set((using "%l", xPoz.id), xPoz.lpSuper)

				for j = 1 to j > xRoz.Count()
						if (xOper = GetObjById("BOperacjaTw",xRoz.item(j).IdOperacji)) then
							if xOper.ownerbase==37 then
								mIdPozMgToIdHn.Set((using "%l", xOper.ownerid), xPoz.id)
							endif
						endif
				next j
			endif
		next i
	next iDokIdx

	// powiazania dla nowych pozycji korekt
	For iDokIdx = 1 To iDokIdx > mIdDocNewPos.Size()	
		xDk = GetObjById("BDokument"+xBazaDok, Val(mIdDocNewPos.GetKey(iDokIdx)))
		For i = 1 To i > xDk.Pozycje.Count
			xPoz = xDk.Pozycje.item(i)
			If xPoz.idPozKoryg == 0 Then
				xRoz = xPoz.Operacja.RozliczeniaTw
				mIdPozMgToLpHn.Set((Using "%l", xPoz.id), xPoz.lpSuper)
				For j = 1 To j > xRoz.Count()
					If (xOper = GetObjById("BOperacjaTw",xRoz.item(j).IdOperacji)) Then
						If xOper.ownerbase == 37 Then
							mIdPozMgToIdHn.Set((Using "%l", xOper.ownerid), xPoz.id)
						EndIf
					EndIf
				Next j
			EndIf
		Next i
	Next iDokIdx

EndSub

long Sub GetConnHnId(long idMz)
// odczytuje z mapy mIdPozMgToIdHn
	GetConnHnId = mIdPozMgToIdHn.Get((using "%l", idMz), 0)
EndSub

int Sub GeConnHnLp(long idMz)
// odczytuje z mapy mIdPozMgToLpHn
	GeConnHnLp = mIdPozMgToLpHn.Get((using "%l", GetConnHnId(idMz)), 0)
EndSub

int Sub AddIdDokKoryg(long idDk)
//dodaje element do mapy tIdDokKoryg
	mIdDokKoryg.Set((using "%l", idDk), 1)
EndSub

int Sub AddIdPosKoryg(long idDp)
// dodaje do mapy mIdPosKoryg
	mIdPosKoryg.Set((using "%l", idDp), 1)
EndSub

Int Sub AddIdDocNewPos(Long idDoc)
	mIdDocNewPos.Set((Using "%l", idDoc), 1)
EndSub

//Mapy i ich obsuga do powizania pozycji magazynowych z handlowymi
//#############################################################################################################

//-----------------------------------------------------------------------------------------------------------
//zmienne typu dispatch
float tot_nettoBaza, tot_vatBaza, tot_bruttoBaza,tot_NettoNpBaza
Float tot_nettoBazaWAL, tot_bruttoBazaWAL,tot_NettoNpBazaWAL
float dok_Netto, dok_Vat, dok_Brutto, dok_NettoNP
int bDokNP = 0	//korekta zbiorcza - korygowany dokument ma skorygowane pozycje NP
int bDokPoz = 0	//korekta zbiorcza - korygowany dokument ma skorygowane pozycje
int CZYNETTO,j,errdp, CzyNP,KolTab1NP(1),StlTab1NP(1),StlTab1HNP(1),StyleNP(1),nInc=1,nt
int Idw,nDostawy,pom
string sNum1, sNum2 

Dispatch xDocument
if !(xDocument=GetObjById("BDokument"+xBazaDok,iddokkoryg)) then XGetObjErr()
Int iTyp=xDocument.Charakter
bKZ=xDocument.czyKZ()		//czy korekta zbiorcza
Int VW=(iTyp==FKW)//Korekta Vat w Walucie
if !xDocument.CzyKorekta then Message "Dokument o ID="+(using "%l",iddokkoryg)+" nie jest korekt" : error ""
dispatch xPoz, xFormaPl, xPozVat
dispatch xKontrahent
dispatch xKontr
dispatch xOdbiorca
dispatch xDzial
dispatch dTmp
dispatch xTowar
//Odczytanie danych firmy z uwzglednieniem daty wystawienia dokumentu (dlatego po zaadowaniu obiektu do xDocument)
Dispatch xParamsFirm
Dispatch xFirma = xFactory.GetObject("BFirma") //najpierw pobieramy globalnie cache'owany obiekt danych firmy (aktualne dane)
if xDocument.DataWystawienia < xFirma.dataOd || xDocument.DataWystawienia > xFirma.dataDo then
	// potrzebujemy dane firmy z innego okresu ni okres obowizywania globalnie pamietanych danych firmy	
	xParamsFirm = xFactory.NewObject("BParamsFirma")	
    xParamsFirm.data = xDocument.DataWystawienia
	xFirma = xFactory.NewObject("BFirma")
	xFirma.Load(xParamsFirm)
endif
dispatch xStawki=xFactory.GetObject("BStawkaVAT")
xPoz=xDocument.Pozycje

#ifdef OO_ONLY
	Int currInd
	For currInd = 1 To currInd > xPoz.Count()
		If !xPoz.Item( currInd ).PoKorekcie.odwrotneObc Then
			Message "Raport jest przeznaczony dla dokumentw z wszystkimi pozycjami z odwrotnym obcieniem."
			Error ""
		EndIf
	Next currInd
#endif

//-------------------------------------------------------------------------------------------------------------
//zmienne uzywane w wydrukach
string sFNazwa=FormatNotatka(xFirma.Nazwa)
string sFKod=xFirma.kod
string sFAdres=xFirma.Adres
string sFNIP=xFirma.Nip
string sFKodPocz=xFirma.KodPocztowy
string sFMiejsce=xFirma.Miejscowosc
string sFRejon=xFirma.Rejon
string sFTel1=xFirma.Telefon1
string sFTel2=xFirma.Telefon2
string sFFax=xFirma.Fax
string sFEmail=xFirma.Email
string sFBank=xFirma.NazwaBanku
string sFKonto=xFirma.NumerRachunku
string sFPesel=xFirma.Pesel
string sFRegon=xFirma.Regon
string sFNotatka=FormatNotatka(xFirma.Notatka)
string sFBDO=xFirma.BDO
int exp_dokument =(iTyp==80 || iTyp==127)
if iTyp==WNK || iTyp==KRW || iTyp==WDK then sFNIP=xFirma.VATUE

if iTyp!=WKS then sNapis= arg9

if xDocument.RodzajCeny==2 then CZYNETTO=1

sNazwaDok = sDajOpisTypu(xBazaDok,xDocument.TypDk)
sNumerDok = xDocument.Numer
Int pobierzDataWystawieniaObca = 0
#ifdef ZAKUP
pobierzDataWystawieniaObca = 1
#endif
#ifdef KONTRAKTZ
pobierzDataWystawieniaObca = 0
#endif
If pobierzDataWystawieniaObca Then
	sDataWyst = xDocument.DataWystawieniaObca
	if !sDataWyst then sDataWyst = xDocument.DataWystawienia
Else
	sDataWyst = xDocument.DataWystawienia
EndIf
xKontr=xDocument.DaneKh
//Na razie wylaczone sprawdzanie czy istnieje kontrahent
if !(xKontrahent=GetObjById("BKontrahent",xKontr.Khid)) then XGetObjErr()
string sNabywca = xKontr.KhNazwa
string sNabKodPocz = xKontr.KhPoczta
string sNabMiasto = xKontr.KhMiasto
string sNabAdres = xKontr.KhAdres
string sNabNip = xKontr.KhNip
string sNabKod = xKontr.KhKod
string sNabTel1 = xKontrahent.Telefon1
string sNabTel2 = xKontrahent.Telefon2
string sNabFax = xKontrahent.Fax
string sNabEMail = xKontrahent.Email
string sNabBankNazwa = xKontrahent.NazwaBanku
//string sNabBankAdres = xKontrahent.AdresBanku
string sNabBankKonto = xKontrahent.NumerRachunku
string sNabPesel = xKontrahent.Pesel
string sNabRegon = xKontrahent.Regon
string sNabKodPocz2 = xKontrahent.KodPocztowy2
string sNabMiasto2 = xKontrahent.Miejscowosc2
string sNabAdres2 = xKontrahent.Adres2
string sNabKrajNazwa = xKontrahent.kraj.nazwa
string sNotatkaKontr = FormatNotatka( xKontrahent.Notatka )
//#ifdef ZAKUP
//	nResult=xOdbiorca.Load("id='"+xDocument.DaneOd.KhKod+"'") : xErr(nResult)
//#else
xKontr.Clear()
xKontr=xDocument.DaneOd
if !(xOdbiorca=GetObjById("BKontrahent",xKontr.Khid)) then XGetObjErr()


string sOdbiorca = xKontr.KhNazwa
string sOdbKodPocz = xKontr.KhPoczta
string sOdbMiasto = xKontr.KhMiasto
string sOdbAdres = xKontr.KhAdres
string sOdbTel1 = xOdbiorca.telefon1
string sOdbTel2 = xOdbiorca.telefon2
string sOdbFax = xOdbiorca.fax
string sOdbEMail = xOdbiorca.Email
string sOdbPesel = xOdbiorca.Pesel
string sOdbRegon = xOdbiorca.Regon
string sOdbKodPocz2 = xKontrahent.KodPocztowy2
string sOdbMiasto2 = xKontrahent.Miejscowosc2
string sOdbAdres2 = xKontrahent.Adres2
string sOdbKrajNazwa = xKontr.kraj.nazwa

string sNrKoryg					//numer i data dok korygowanego
Int	   sNrKorygMax = 5			// pierwszych 5 korekt drukowanych w osobnych liniach
String sNrKorygExtra			// pozostale drukowane ciaglym tekstem (tfs157712)
String sDataKoryg //data pierwszego dokumentu korygowanego
string sDataTmp
string sDataObca

#ifdef ZAKUP
	string sNazwaBanku=xKontrahent.NazwaBanku
	string sKonto=xKontrahent.numerRachunku
	int bIsSwift=0
	string sSwift=""
	if xBazaDOk!="Zw" then
		sDataObca = xDocument.DataWystawieniaObca
	endif
#endif
#ifdef FAKT_KOR_WEWN
sDataKoryg = xDocument.DokumentZKorektami.item( 1 ).Data
#endif
Dispatch korygowany
Float    fKursPrzed = -1
for i=1 to i>xDocument.DokumentZKorektami.Count()
	if xDocument.DokumentZKorektami.item(i).Numer!= xDocument.Numer then
		#ifdef ZAKUP
		if xBazaDOk!="Zw" then
			if dTmp then dTmp.Clear()
			dTmp=GetObjById("BDokument"+xBazaDok,xDocument.DokumentZKorektami.item(i).id)
			if dTmp then
				sDataTmp=dTmp.DataWystawieniaObca
			endif
			if !sDataTmp then 	sDataTmp = xDocument.DokumentZKorektami.item(i).Data
			dTmp.Clear()
		else
			sDataTmp = xDocument.DokumentZKorektami.item(i).Data
		endif
#else	
		sDataTmp = xDocument.DokumentZKorektami.item(i).Data
#endif
#ifndef ZAKUP
		If i <= sNrKorygMax Then
#endif
			sNrKoryg+=xDocument.DokumentZKorektami.item(i).Numer+", "+sDataTmp+"\n"
#ifndef ZAKUP
		Else
			sNrKorygExtra += xDocument.DokumentZKorektami.item( i ).Numer + ", " + sDataTmp + "   ;   "
		EndIf
#endif
	else
#ifdef WDK_ANG
		If i > 1 && (korygowany = GetObjByKod("BDokumentSp", xDocument.DokumentZKorektami.item(i-1).Numer)) Then
			fKursPrzed = korygowany.kurs
		EndIf
#endif
		exit
	endif
next i
sNrKoryg=mid(sNrKoryg,1,len(sNrKoryg)-1)
If sNrKorygExtra != "" Then
	sNrKorygExtra = Mid( sNrKorygExtra , 0 , Len( sNrKorygExtra ) - 7 )
EndIf

string sTerminPlat = xDocument.terminPlatnosci
string sWaluta = xDocument.Waluta
string sKodObcy
string sDataWpl
string sDataSp

// ################################################################################
// ###############       identyczne w DOKENG.SCI i KORENG.SCI       ###############
// ################################################################################

// wydruk ( korekty ) kontraktu walutowego oraz ( korekty ) zaliczki walutowej

#ifndef PLN_ONLY_DEFINED
#define PLN_ONLY_DEFINED

Int PLNonly = -1		// -1	dokument inny niz SKW / SKWK / SZW / SZWK
						//  0	ceny i wartosci w walucie
						//  1	ceny i wartosci w PLN

#endif // PLN_ONLY_DEFINED

// informacja w naglowku ramek czy wartosci walutowe czy w PLN

String Sub fcSuffix()
	fcSuffix = IIF( PLNonly == 1, " w PLN", IIF( PLNonly == 0, " w " + sWaluta, "" ) )
EndSub

String Sub fcSuffixVAT()
	fcSuffixVAT = IIF( PLNonly == -1, "", " w PLN" )
EndSub

// ################################################################################

if sWaluta != "" && iTyp ==  WKZ then czyKursWaluty = 1
int bAnulowano = xDocument.CzyAnulowany
#ifdef ZAKUP
	if xBazaDOk!="Zw" then
	if dTmp then dTmp.Clear()
	dTmp=GetObjById("BDokument"+xBazaDok,xDocument.idKorygowany)
	if dTmp then
		sDataSp=dTmp.DataZakupu
	endif
	dTmp.Clear()
	endif
	sDataWpl=xDocument.DataWplywu
#else
	sDataSp=xDocument.DataSprzedazy
#endif
#ifdef NIEKONTRAKTZ
	sKodObcy=xDocument.NumerObcy
#endif
float fKurs = xDocument.Kurs
float fKursDoch = xDocument.KursDoch
float fWplaty
float fWplatyWal

float fDoZaplatyWal
float fDozaplaty
float WartoscDoZap
float WartoscZaplacona

fDoZaplaty=xDocument.rzeczywistaWysokoscNaleznosci
fDoZaplatyWal=round(fDoZaplaty/fkurs,2)

if (xBazaDok=="Zo" || xBazaDok == "Zw") && sign(xDocument.WartoscWWalucie) then  fDoZaplatyWal=xDocument.WartoscWWalucie



string sub DajNIP( string NIP )
// funkcja zwraca "REGON: ","PESEL: ","NIP: "
// w zmiennej buf zwraca cig odpowiednich cyfr
	buf=NIP
	if find regular "{[rRpP]}/:{*$}" then
		Select Case regular 1
		Case "R","r"
			DajNip = "REGON: "
		Case "P","p"
			DajNip = "PESEL: "
		EndSelect
		NIP = regular 2
		buf = NIP
	else
		DajNIP="NIP: "
		buf = NIP
	endif
endsub

string sub DajNIPe( string NIP )
// funkcja zwraca "REGON: ","PESEL: ","VAT id no: "
// w zmiennej buf zwraca cig odpowiednich cyfr
	buf=NIP
	if find regular "{[rRpP]}/:{*$}" then
		Select Case regular 1
		Case "R","r"
			DajNIPe = "REGON: "
		Case "P","p"
			DajNIPe = "PESEL: "
		EndSelect
		NIP = regular 2
		buf = NIP
	else
		DajNIPe="VAT id no: "
		buf = NIP
	endif
endsub

#include "Engine do funduszy promocji rolnych"

int sub Plat(int bAktualny)

int i
int czyRR = 0
dispatch xRoz
dispatch xPn
string dataPn

#ifdef VATRR
	czyRR = 1
#endif

fWplaty=fWPlatyWal=0 //fDozaplaty=fDozaplatyWal=0
	if xBazaDok!="Zo" && xBazaDok != "Zw" && xDocument.rozrachunek then
		xRoz=xDocument.rozrachunek
		if xRoz.RozliczeniaPn.Count() then
			for i=1 to i>xRoz.RozliczeniaPn.Count
				if xRoz.RozliczeniaPn.item(i).CzyRozliczenieZFK then
					dataPn = xRoz.RozliczeniaPn.item(i).dataSecPn
				else
					if xPn then xPn.Clear()
					xPn=GetObjById("BDokumentPn",xRoz.RozliczeniaPn.item(i).idSecPn)
					dataPn = xPn.data_Platnosci
				endif
				if bAktualny || dataPn<=xDocument.DataWystawienia  then
					fWplaty+=xRoz.rozliczeniaPn.item(i).wartoscPLN
					fWplatyWal+=xRoz.rozliczeniaPn.item(i).wartosc

#ifdef PLATWYD
					If bPlatnosci Then
						Grow Platnosci, IIF(Platnosci(Size(Platnosci))=="",2,3)
						AddPlatWal(xRoz.RozliczeniaPn.Item(i).WalutaSecPn,xRoz.RozliczeniaPn.Item(i).Wartosc,xRoz.RozliczeniaPn.Item(i).WartoscSecPn)
						Platnosci(Size(Platnosci)-2) = xRoz.RozliczeniaPn.Item(i).NumerSecPn
						Platnosci(Size(Platnosci)-1) = xRoz.RozliczeniaPn.Item(i).DataSecPn
						Platnosci(Size(Platnosci)) = Kwota(xRoz.RozliczeniaPn.Item(i).WartoscPLN)
					EndIf
#endif

				endif
			next i
		endif
		if xRoz.wyplata & 0x01 then fWplaty*=(-1):fWplatyWal*=(-1)
		if !xRoz.waluta then
			CzyRozrWal=0
			fWplatyWal=round(fWplatyWal/xDocument.Kurs,2)
			//dla dokumentw zakupu uwzgldniamy wpaty na FP
			//jedynie dla wydrukw RR
			if 	xBazaDok == "Zk" && !czyRR then
				fDoZaplaty=-OdejmijFP(-xDocument.rzeczywistaWysokoscNaleznosci)
			else
				fDoZaplaty=xDocument.rzeczywistaWysokoscNaleznosci
			endif
			fDoZaplatyWal=round(fDoZaplaty/xDocument.kurs,2)
		else
			CzyRozrWal=1
			fDoZaplatyWal=xDocument.rzeczywistaWysokoscNaleznosci
			fDoZaplaty=round(fDoZaplatyWal*xDocument.kurs,2)
		endif
	else
			fDoZaplaty = xDocument.Wartosc
			if BUFOR then
				fDoZaplatyWal = xDocument.Wartoscwwalucie
			else
				fDoZaplatyWal = xDocument.rzeczywistaWysokoscNaleznosci
			endif
	endif
endsub


string sOpis = xDocument.Opis
string sNotat=FormatNotatka(xDocument.Notatka)
string sPlatName=xDocument.FormaPl.Nazwa
long sNrParagonuFisk=xDocument.paragon
string sNrUnikatowyKasy=xDocument.fiscalDeviceNo


#ifndef ZAKUP
//Rejestr bankowy
dispatch xRejestr
if !(xRejestr=GetObjById("BRejestr",xDocument.rejestr.id)) then XGetObjErr()
string sNazwaBanku=xRejestr.bank
string sKonto=xRejestr.rachunek
string sSwift=xRejestr.swift
int bIsSwift= sSwift != ""
#endif


//********************************************************************
string sNotatRodz

//*******************************************************************
int sub DajNotatki()
#ifndef ZAKUP
	if dTmp=GetObjById("BRodzaj"+xBazaDok,xDocument.Rodzaj.Id) then sNotatRodz=FormatNotatka(dTmp.Notatka)
	dTmp.Clear()
#else
	if DokZakupu then
		if dTmp=GetObjById("BRodzajZk",xDocument.Rodzaj.Id) then sNotatRodz=FormatNotatka(dTmp.Notatka)
		dTmp.Clear()
	endif
#endif
endsub

string sub fMiejsceWyst()


	if !(xDzial=GetObjByKod("BDzial",xDocument.Dzial.Kod)) then MiejsceWyst=xFirma.Miejscowosc : exit

	if xDzial.Miejscowosc then
		MiejsceWyst=xDzial.Miejscowosc
	else
		MiejsceWyst=xFirma.Miejscowosc
	endif
	if xDzial.wydruk then
		sFNazwa=xDocument.dzial.nazwa
 		sFKod=xDocument.dzial.kod
 		sFAdres=xDzial.Adres
 		sFKodPocz=xDzial.kodPocztowy
 		sFMiejsce=xDzial.miejscowosc
 		sFRejon=xDzial.Rejon
 		sFTel1=xDzial.Telefon1
 		sFTel2=xDzial.Telefon2
 		sFFax=xDzial.Fax
		sFEmail=xDzial.Email
	endif
	xDzial.Clear()
endsub

string sub KodPaskowy_Pozycji(string sKod)

	if !(xTowar=GetObjByKod("BTw",sKod)) then XGetObjErr()
	KodPaskowy_Pozycji=xTowar.KodPaskowy


endsub

int sub UtworzStawkiVat()
dispatch Przed,Po
int i,j
string stmp
	for i=1 to i>xStawki.Count()
		if !xStawki.item(i).czyNpOld && xStawki.item(i).Nazwa!="-" && xStawki.item(i).aktywny then
			j+=1
			if StPrzed(1).Nazwa then grow StPrzed,1:grow StPo,1:grow StKorekta,1
			StPrzed(j).Nazwa=StKorekta(j).Nazwa=StPo(j).Nazwa=xStawki.item(i).Nazwa
		endif
	next i
	for i=1 to i>size(Korekty)
		for j=1 to j>size(StKorekta)
			if Stkorekta(j).Nazwa==Korekty(i).StVat then
				StKorekta(j).Netto+=Korekty(i).WartoscNetto
				StKorekta(j).Vat+=Korekty(i).KwotaVat
				StKorekta(j).Brutto+=Korekty(i).WartoscBrutto
				StKorekta(j).NettoWal += Korekty(i).NettoWal
				StKorekta(j).BruttoWal += Korekty(i).BruttoWal
				exit
			endif
		next j
	next i
	for i=1 to i>xPoz.Count()
		if !xPoz.item(i).dokompletu && xPoz.item(i).wlasna then
			Przed=xPoz.item(i).PrzedKorekta
			Po=xPoz.item(i).PoKorekcie
			for j=1 to j>size(StPrzed)
				if StPrzed(j).Nazwa==Przed.StVat.Nazwa then
					StPrzed(j).Netto+=Przed.Netto
					StPrzed(j).Vat+=Przed.Vat
					StPrzed(j).Brutto+=Przed.Brutto
					StPrzed(j).NettoWal += Przed.NettoWal
					StPrzed(j).BruttoWal += Przed.BruttoWal
					exit
				endif
			next j
			for j=1 to j>size(StPo)
				if StPo(j).Nazwa==Po.StVat.Nazwa then
					StPo(j).Netto+=Po.Netto
					StPo(j).Vat+=Po.Vat
					StPo(j).Brutto+=Po.Brutto
					StPo(j).Opis = Po.Opis
					StPo(j).NettoWal += Po.NettoWal
					StPo(j).BruttoWal += Po.BruttoWal
					exit
				endif
			next j
		endif
	next i
endsub

int sub UtworzStawkiVatDokKor()
int i,j
	for i=1 to i>xStawki.Count()
		if lcase(xStawki.item(i).Nazwa)!="np" && xStawki.item(i).Nazwa!="-" && xStawki.item(i).aktywny  then
			j+=1
			if StDokKor(1).Nazwa then grow StDokKor,1
			StDokKor(j).Nazwa=xStawki.item(i).Nazwa
		endif
	next i
endsub

int sub ClearStawkiVatDokKor()
int i
	for i=1 to i>size(StDokKor)
		StDokKor(i).Netto=0.0
		StDokKor(i).Vat=0.0
   		StDokKor(i).Brutto=0.0
	next i
endsub

int sub SumujStawkiVatDokKor(int i)
int j	
	for j=1 to j>size(StDokKor)
		if StDokKor(j).Nazwa==Korekty(i).StVat then
			StDokKor(j).Netto+=Korekty(i).WartoscNetto
			StDokKor(j).Vat+=Korekty(i).KwotaVat
			StDokKor(j).Brutto+=Korekty(i).WartoscBrutto
			StDokKor(j).NettoWal += Korekty(i).NettoWal
			StDokKor(j).BruttoWal += Korekty(i).BruttoWal
			exit
		endif
	next j
endsub
	
int sub UtworzKorekty()

int i,nRes
dispatch Przed,Po
float fPrzedJmDod,fPoJmDod
int nLp,bFirstNP
long lParent = 0
int bKorektaVat = 0
int bKorektaIlosc = 0
int bKorektaCena = 0
int bWieloKorekta = 0

	for i=1 to i>xPoz.Count()
		if !xPoz.item(i).niepodlega then czyPozPodlega=1
		if bKZ && lParent != xPoz.item(i).idsuperkoryg then
			lParent = xPoz.item(i).idsuperkoryg
			nLp = 1 : bFirstNP = 1
		endif
		if bFirstNP && !czyPozPodlega then
			bFirstNP = 0
			nLp = 1
		endif

		if xPoz.item(i).wlasna then
		if !xPoz.item(i).dokompletu then
		if xPoz.item(i).czyNpOld then //xPoz.item(i).PrzedKorekta.NiePodlega then

			//Dla pierwszej pozycji NP wyzeroj licznik pozycji
			//bo NP za w innych tabelach
			if bKZ && !CZYNP then nLp = 1


			Select case xDocument.Charakter
				case FKS,FKW,FKZ,RKZ,FKR,FKM,DKM,WNK,WKS,WKZ,ZSK,ZZK,ZKS,ZKZ,DXK,WDK,SZK,ZWK,PRK,SZWK,FTK
					CZYNP=1
				case else
					CZYNP=0
			endselect
		endif
		Tmp.lp = IIF(bKZ, nLp, xPoz.item(i).lp)
		if bKZ then nLp += 1
		Tmp.Kod=xPoz.item(i).Kod
		Tmp.iOO=xPoz.item(i).odwrotneObc
		Tmp.superkoryg=xPoz.item(i).idSuperKoryg
		Tmp.Opis=(using "K%d %d",Tmp.lp, xPoz.item(i).idsuperkoryg) + IIF(xPoz.item(i).czyNpOld,"NP","")
		mPozOpis.Set(Tmp.Opis,xPoz.item(i).Opis)
		nRes=xPoz.item(i).PodajKodObcy() : xErr(nRes)
		if nRes then Message sStndError : error ""
		Tmp.KodObcy=xPoz.item(i).KodObcy
		Tmp.Sww=xPoz.item(i).PKWiU
		Tmp.GTU=xPoz.item(i).JPK_V7
		Tmp.flagi = xPoz.item(i).flagi
		Tmp.PrzelJmDod=0
		if xPoz.item(i).IloscWP then Tmp.PrzelJmDod=xPoz.item(i).Ilosc/xPoz.item(i).IloscWP
		if !Tmp.PrzelJmDod then Tmp.PrzelJmDod=1
		Tmp.Cena=xPoz.item(i).Cena
		Tmp.CenaWP=xPoz.item(i).CenaWP*xDocument.Kurs //fKurs
		if Tmp.Cena==Tmp.CenaWP && Tmp.PrzelJmDod!=1 && Tmp.PrzelJmDod then Tmp.Cena=Tmp.Cena/Tmp.PrzelJmDod
		Tmp.NiePodlega=xPoz.item(i).NiePodlega
		Tmp.WartoscNetto=xPoz.item(i).Netto
		Tmp.WartoscBrutto=xPoz.item(i).Brutto
		Tmp.KwotaVat=xPoz.item(i).Vat

		Tmp.nettoWal = xPoz.item(i).niePodlegaWal+xPoz.item(i).NettoWal
		Tmp.bruttoWal=xPoz.item(i).bruttoWal

		#ifndef ZAKUP
			Tmp.Rabaty=xPoz.item(i).Rabat*100
		#endif
		Przed=xPoz.item(i).PrzedKorekta
		Po=xPoz.item(i).PoKorekcie
		fPrzedJmDod=fPoJmDod=0
		if Przed.IloscWP then
			fPrzedJmDod=Przed.Ilosc/Przed.IloscWP
		else
			if !Przed.Ilosc then fPrzedJmDod=Tmp.PrzelJmDod
		endif
		if Po.IloscWP then fPoJmDod=Po.Ilosc/Po.IloscWP
		if !sign(Po.Ilosc,6) && !fPoJmDod && xPoz.item(i).IloscWP then fPoJmDod=xPoz.item(i).Ilosc/xPoz.item(i).IloscWP
		if !fPrzedJmDod then fPrzedJmDod=1
		if !fPoJmDod then fPoJmDod=1

		bKorektaVat = Przed.StVat.Nazwa!=Po.StVat.Nazwa //korekta Vat
		bKorektaIlosc = Przed.Ilosc!=Po.Ilosc && xPoz.item(i).Ilosc
		bKorektaCena = Sign(Przed.CenaWP-(Po.CenaWP/Round(fPoJmDod, 4))* Round(fPrzedJmDod, 4),4) || ( bKZ && Sign( Przed.Wartosc - Po.Wartosc, 2 ) )

		//skorygowany wicej ni jeden element np, stawka i ilo, ilo i cena itp.
		bWieloKorekta = (bKorektaVat && bKorektaIlosc) || (bKorektaIlosc && bKorektaCena) || (bKorektaVat && bKorektaCena)

		if bKorektaVat then //korekta Vat
			if !Korekty(1).lp && size(Korekty)==1 then grow Korekty, 1
			if Korekty(size(Korekty)).lp then grow Korekty, 2
			Korekty(size(Korekty)-1)=Korekty(size(Korekty))=Tmp
			Korekty(size(Korekty)-1).lp=IIF(bKZ, Tmp.lp, xPoz.item(i).lp)
			Korekty(size(Korekty)-1).lpsuper=xPoz.item(i).lpsuper
			Korekty(size(Korekty)-1).superkoryg=xPoz.item(i).idSuperKoryg
			Korekty(size(Korekty)-1).Ilosc=-Przed.Ilosc
			Korekty(size(Korekty)-1).IloscWP=-Przed.IloscWP
			Korekty(size(Korekty)).Jm=Korekty(size(Korekty)-1).Jm=Przed.JednostkaMiary
			Korekty(size(Korekty)).JmWP=Korekty(size(Korekty)-1).JmWP=Przed.JednostkaMiaryWP
			Korekty(size(Korekty)-1).nKorStat=Korekty(size(Korekty)).nKorStat=1
			Korekty(size(Korekty)-1).KorTytul=Korekty(size(Korekty)).KorTytul="KOREKTY STAWKI VAT:"
			Korekty(size(Korekty)-1).Cena=Przed.Cena/fPrzedJmDod
			Korekty(size(Korekty)-1).CenaWP=Przed.CenaWP*fKurs
			if !Tmp.NiePodlega then
				if CZYNETTO then
					Korekty(size(Korekty)-1).CenaNetto=Przed.Cena/fPrzedJmDod
					Korekty(size(Korekty)-1).CenaBrutto=(Przed.Cena+Przed.Cena*Przed.StVat.Wartosc)/fPrzedJmDod
				else
					Korekty(size(Korekty)-1).CenaBrutto=Przed.Cena/fPrzedJmDod
					Korekty(size(Korekty)-1).CenaNetto=(Przed.Cena/(1+Przed.StVat.Wartosc))/fPrzedJmDod
				endif
			endif
			#ifndef ZAKUP
			Korekty(size(Korekty)-1).Rabaty=Przed.Rabat*100
			#endif
			Korekty(size(Korekty)-1).PrzelJmDod=fPrzedJmDod
			//if Przed.IloscWP then Korekty(size(Korekty)-1).PrzelJmDod=Przed.Ilosc/Przed.IloscWP

			if bWieloKorekta then
				Korekty(size(Korekty)-1).WartoscNetto=Korekty(size(Korekty)-1).Ilosc*Korekty(size(Korekty)-1).CenaNetto
				Korekty(size(Korekty)-1).kwotaVat=Korekty(size(Korekty)-1).WartoscNetto*Przed.StVat.Wartosc
				Korekty(size(Korekty)-1).WartoscBrutto=Korekty(size(Korekty)-1).WartoscNetto+Korekty(size(Korekty)-1).KwotaVat
			else
				Korekty(size(Korekty)-1).WartoscNetto=-Przed.Netto
				Korekty(size(Korekty)-1).kwotaVat=-Przed.Vat
				Korekty(size(Korekty)-1).WartoscBrutto=-Przed.Brutto
			endif

			Korekty(size(Korekty)-1).StVat=Przed.StVat.nazwa
			Korekty(size(Korekty)-1).czyNPo=Przed.czyNPOld
			Korekty(size(Korekty)-1).iOO=Przed.odwrotneObc
			//--------------------------------------------
			Korekty(size(Korekty)).lp=IIF(bKZ, Tmp.lp, Korekty(size(Korekty)-1).lp)
			Korekty(size(Korekty)).lpsuper=Korekty(size(Korekty)-1).lpsuper
			Korekty(size(Korekty)).superkoryg=Korekty(size(Korekty)-1).superkoryg
			Korekty(size(Korekty)).Ilosc=-Korekty(size(Korekty)-1).Ilosc
			Korekty(size(Korekty)).IloscWP=-Korekty(size(Korekty)-1).IloscWP
			Korekty(size(Korekty)).Cena=Korekty(size(Korekty)-1).Cena//Tmp.PrzelJmDod
			Korekty(size(Korekty)).CenaWP=Korekty(size(Korekty)-1).CenaWP
			if !xPoz.item(i).czyNpOld then
				if CZYNETTO then
					Korekty(size(Korekty)).CenaNetto=Przed.Cena/fPrzedJmDod
					Korekty(size(Korekty)).CenaBrutto=(Przed.Cena+Przed.Cena*Po.StVat.Wartosc)/fPrzedJmDod
				else
					Korekty(size(Korekty)).CenaBrutto=Przed.Cena/fPrzedJmDod
					Korekty(size(Korekty)).CenaNetto=(Przed.Cena/(1+Po.StVat.Wartosc))/fPrzedJmDod
				endif
			endif
			#ifndef ZAKUP
				Korekty(size(Korekty)).Rabaty=Przed.Rabat*100
			#endif
			Korekty(size(Korekty)).PrzelJmDod=Korekty(size(Korekty)-1).PrzelJmDod

			if bWieloKorekta then
				Korekty(size(Korekty)).WartoscNEtto=Korekty(size(Korekty)).Ilosc*Korekty(size(Korekty)).CenaNetto
				Korekty(size(Korekty)).KwotaVat=Korekty(size(Korekty)).WartoscNetto*Po.StVat.Wartosc
				Korekty(size(Korekty)).WartoscBrutto=Korekty(size(Korekty)).WartoscNetto+Korekty(size(Korekty)).kwotaVat
			else
				Korekty(size(Korekty)).WartoscNEtto=Po.Netto
				Korekty(size(Korekty)).KwotaVat=Po.Vat
				Korekty(size(Korekty)).WartoscBrutto=Po.Brutto
			endif

			Korekty(size(Korekty)).StVat=Po.StVat.Nazwa
			Korekty(size(Korekty)).czyNPo=Po.czyNPOld
			Tmp.WartoscNetto-=Korekty(size(Korekty)-1).WartoscNetto+Korekty(size(Korekty)).WartoscNetto
			//Przed.Netto-Korekty(size(Korekty)-1).WartoscNetto-Korekty(size(Korekty)).WartoscNetto
			Tmp.KwotaVat-=Korekty(size(Korekty)-1).KwotaVat+Korekty(size(Korekty)).KwotaVat
			//Przed.Vat-Korekty(size(Korekty)-1).KwotaVat-Korekty(size(Korekty)).KwotaVat
			Tmp.WartoscBrutto-=Korekty(size(Korekty)-1).WartoscBrutto+Korekty(size(Korekty)).WartoscBrutto
			//Przed.Brutto-Korekty(size(Korekty)-1).WartoscBrutto-Korekty(size(Korekty)).WartoscBrutto
			Korekty(size(Korekty)).iOO=Po.odwrotneObc
		endif

		if bKorektaIlosc then //korekta ilosc
			if Korekty(size(Korekty)).lp then grow Korekty, 1
			Korekty(size(Korekty))=Tmp
			Korekty(size(Korekty)).lp=IIF(bKZ, Tmp.lp, xPoz.item(i).lp)
			Korekty(size(Korekty)).lpsuper=xPoz.item(i).lpsuper
			Korekty(size(Korekty)).iOO=Po.odwrotneObc
			Korekty(size(Korekty)).superkoryg=xPoz.item(i).idSuperKoryg
			Korekty(size(Korekty)).Ilosc=xPoz.item(i).Ilosc
			Korekty(size(Korekty)).IloscWP=xPoz.item(i).IloscWP
			Korekty(size(Korekty)).Jm=xPoz.item(i).JednostkaMiary
			Korekty(size(Korekty)).JmWP=xPoz.item(i).JednostkaMiaryWP
			Korekty(size(Korekty)).nKorStat=2
			Korekty(size(Korekty)).KorTytul="KOREKTY ILOCI:"
			Korekty(size(Korekty)).PrzelJmDod=fPoJmDod
			Korekty(size(Korekty)).Cena=Przed.Cena/Tmp.PrzelJmDod
			//if Przed.IloscWP then Korekty(size(Korekty)).Cena/=(Przed.Ilosc/Przed.IloscWP)
			Korekty(size(Korekty)).CenaWP=Przed.CenaWP*fKurs
			if sign(Korekty(size(Korekty)).PrzelJmDod-fPrzedJmDod,6) then
				Korekty(size(Korekty)).IloscWP=Korekty(size(Korekty)).Ilosc/fPoJmDod
				Korekty(size(Korekty)).Cena= Przed.Cena/fPrzedJmDod
				Korekty(size(Korekty)).CenaWP=Przed.CenaWP*fPoJmDod/fPrzedJmDod*fKurs
			endif

			if !xPoz.item(i).czyNpOld then

				if CZYNETTO then
					Korekty(size(Korekty)).CenaNetto=Korekty(size(Korekty)).Cena//Przed.Cena
					Korekty(size(Korekty)).CenaBrutto=Korekty(size(Korekty)).Cena+Korekty(size(Korekty)).Cena*Po.StVat.Wartosc
				else
					Korekty(size(Korekty)).CenaBrutto=Korekty(size(Korekty)).Cena
					Korekty(size(Korekty)).CenaNetto=Korekty(size(Korekty)).Cena/(1+Po.StVat.Wartosc)
				endif
			else
				Korekty(size(Korekty)).NiePodlega=Korekty(size(Korekty)).Ilosc*Korekty(size(Korekty)).Cena
			endif
			#ifndef ZAKUP
				Korekty(size(Korekty)).Rabaty=Przed.Rabat*100
			#endif
			Korekty(size(Korekty)).StVat=Po.StVat.Nazwa
			Korekty(size(Korekty)).czyNPo=Po.czyNPOld
			if !Sign(Przed.CenaWP-(Po.CenaWP/fPoJmDod)*fPrzedJmDod,4) then // brak korekty ceny
				Korekty(size(Korekty)).WartoscNetto=Tmp.WartoscNetto
				Korekty(size(Korekty)).KwotaVat=Tmp.KwotaVat
				Korekty(size(Korekty)).WartoscBrutto=Tmp.WartoscBrutto
				Korekty(size(Korekty)).NiePodlega=Tmp.NiePodlega
			else //jest korekta ceny
				Korekty(size(Korekty)).WartoscNetto=Korekty(size(Korekty)).Ilosc*Korekty(size(Korekty)).CenaNetto
				Korekty(size(Korekty)).KwotaVat=Korekty(size(Korekty)).WartoscNetto*Po.StVat.Wartosc
				Korekty(size(Korekty)).WartoscBrutto=Korekty(size(Korekty)).WartoscNetto+Korekty(size(Korekty)).KwotaVat
				Tmp.WartoscNetto-=Korekty(size(Korekty)).WartoscNetto
				Tmp.KwotaVat-=Korekty(size(Korekty)).KwotaVat
				Tmp.WartoscBrutto-=Korekty(size(Korekty)).WartoscBrutto
			endif
		endif
																	// korekty zbiorcze moga miec zaokraglona cene ( wskutek bledu ? )
		if bKorektaCena then //korekty ceny
			if Korekty(size(Korekty)).lp then grow Korekty, 1
			Korekty(size(Korekty))=Tmp
			Korekty(size(Korekty)).lp=IIF(bKZ, Tmp.lp, xPoz.item(i).lp)
			Korekty(size(Korekty)).lpsuper=xPoz.item(i).lpsuper
			Korekty(size(Korekty)).superkoryg=xPoz.item(i).idSuperKoryg
			Korekty(size(Korekty)).iOO=Po.odwrotneObc
			Korekty(size(Korekty)).Ilosc=Po.Ilosc
			Korekty(size(Korekty)).IloscWP=Po.IloscWP
			Korekty(size(Korekty)).PrzelJmDod=fPoJmDod
			Korekty(size(Korekty)).Jm=xPoz.item(i).JednostkaMiary
			Korekty(size(Korekty)).JmWP=xPoz.item(i).JednostkaMiaryWP
			Korekty(size(Korekty)).nKorStat=3
			Korekty(size(Korekty)).KorTytul="KOREKTY CENY:"
			Korekty(size(Korekty)).Cena=(Po.Cena-Przed.Cena)/fPoJmDod
			Korekty(size(Korekty)).CenaWP=(Po.CenaWP-Przed.CenaWP)*fKurs
			if fPrzedJmDod!=fPoJmDod then
				Korekty(size(Korekty)).Cena=Po.Cena-Przed.Cena*fPoJmDod
			//	Korekty(size(Korekty)).Cena=Korekty(size(Korekty)).Cena/fPoJmDod
				Korekty(size(Korekty)).CenaWP=(Po.CenaWP-Przed.CenaWP*fPoJmDod)*fKurs
			endif
			if !xPoz.item(i).czyNpOld then
				if CZYNETTO then
					Korekty(size(Korekty)).CenaNetto=Korekty(size(Korekty)).Cena///Tmp.PrzelJmDod
					Korekty(size(Korekty)).CenaBrutto=(Korekty(size(Korekty)).CenaNetto+Korekty(size(Korekty)).CenaNetto+xPoz.item(i).StVat.Wartosc)//Tmp.PrzelJmDod
				else
					Korekty(size(Korekty)).CenaBrutto=Korekty(size(Korekty)).Cena//Tmp.PrzelJmDod
					Korekty(size(Korekty)).CenaNetto=(Korekty(size(Korekty)).CenaBrutto/(1+xPoz.item(i).StVat.Wartosc))//Tmp.PrzelJmDod
				endif
			else
				Korekty(size(Korekty)).NiePodlega=Korekty(size(Korekty)).Ilosc*(Korekty(size(Korekty)).Cena)//Korekty(size(Korekty)).PrzelJmDod)
			endif
//			Korekty(size(Korekty)).WartoscNetto=Korekty(size(Korekty)).Ilosc*Korekty(size(Korekty)).CenaNetto
//			Korekty(size(Korekty)).KwotaVat=Korekty(size(Korekty)).WartoscNetto*Po.StVat.Wartosc
//			Korekty(size(Korekty)).WartoscBrutto=Korekty(size(Korekty)).WartoscNetto+Korekty(size(Korekty)).KwotaVat
			Korekty(size(Korekty)).StVat=xPoz.item(i).StVat.Nazwa
			Korekty(size(Korekty)).czyNPo=xPoz.item(i).czyNPOld
		endif
		Tmp.ClearPoz()
		endif
		else
			if bKZ && !xPoz.item(i).dokompletu then nLp += 1
		endif
	next i
endsub

int sub UtworzPrzed_Po(string ch,dispatch dObiekt,InfoPoz Poz)
int nRes
	Poz.lp=dObiekt.lp
	Poz.lpsuper=dObiekt.lpsuper
	Poz.superkoryg=dObiekt.idSuperKoryg
	if dObiekt.czyNpOld then Poz.lp=xPoz.item(xInd).lp
	Poz.Opis=(using "%s%d",ch,dObiekt.lp)+IIF(dObiekt.czyNpOld,"NP","")
	mPozOpis.Set(Poz.Opis,dObiekt.Opis)
	Poz.Kod=dObiekt.Kod
	nRes=dObiekt.PodajKodObcy() : xErr(nRes)
	if nRes then Message sStndError : error ""
	Poz.KodObcy=dObiekt.KodObcy
	Poz.SWW=dObiekt.PKWiU
	Poz.GTU=dObiekt.JPK_V7
	Poz.flagi = dObiekt.flagi
	if dObiekt.IloscWP then Poz.PrzelJmDod=dObiekt.Ilosc/dObiekt.IloscWP
	if !sign(dObiekt.Ilosc,6) && !Poz.PrzelJmDod && xPoz.item(xInd).IloscWP then Poz.PrzelJmDod=xPoz.item(xInd).Ilosc/xPoz.item(xInd).IloscWP
	if !Poz.PrzelJmDod then Poz.PrzelJmDod=1
	Poz.Ilosc=dObiekt.Ilosc
	Poz.IloscWP=dObiekt.IloscWP
	Poz.Jm=dObiekt.JednostkaMiary
	Poz.JmWp=dObiekt.JednostkaMiaryWP
	Poz.Cena=dObiekt.Cena/Poz.PrzelJmDod
	Poz.CenaWP=dObiekt.CenaWP*fKurs
	if !dObiekt.NiePodlega then
		if CZYNETTO then
			Poz.CenaNetto=Poz.Cena
			Poz.CenaBrutto=Poz.Cena+Poz.Cena*dObiekt.StVat.Wartosc
		else
			Poz.CenaBrutto=Poz.Cena
			Poz.CenaNetto=Poz.Cena/(1+dObiekt.StVat.Wartosc)
		endif
	else
		Poz.NiePodlega=dObiekt.NiePodlega
	endif
	Poz.WartoscNetto=dObiekt.netto
	Poz.WartoscBrutto=dObiekt.Brutto
	Poz.StVat=dObiekt.StVat.Nazwa
	Poz.czyNpo=dObiekt.czyNPOld
	Poz.KwotaVat=dObiekt.Vat
	Poz.nettoWal=dObiekt.nettoWal + dObiekt.niePodlegaWal
	Poz.bruttoWal=dObiekt.bruttoWal
	Poz.iOO=dObiekt.odwrotneObc
	#ifndef ZAKUP
		Poz.Rabaty=dObiekt.rabat*100
	#endif
endsub

//-----------------------------------------------------------------------------------------------------------
//procedury potrzebne do wydrukow

string sub DajNazwe( string nazwa, int lth )
	string sPom
	if lth then
		buf = nazwa
		while find regular "{*}(\n)|($)-"
			sPom = regular 1
			while sPom
				DajNazwe += Mid( sPom, 1, lth ) + lf
				sPom = Mid( sPom, lth+1 )
			wend
		wend
	else
		DajNazwe = nazwa + lf
	endif
endsub





int Sub ZbierzDostawy(dispatch xPozDost, int typ)
int j,z
dispatch xRez,xDw

	xRez=xPozDost.Wlasciwosci.Rezerwacje
	for j=1 to j>xRez.Count()
		if xRez.item(j).Typ==2 then
			xDw=xRez.item(j).Powiazania
			for z=1 to z>xDw.Count()
				if xDw.item(z).Ilosc && !mDst.Index( using "%s,%d,%d",xDw.item(z).Dostawa,xPozDost.Lpsuper,typ) then
					if Dostawy(size(Dostawy)).Nazwa then grow Dostawy, 1
					mDst.Set((using "%s,%d",xDw.item(z).Dostawa,xPozDost.Lpsuper),1)
					Dostawy(size(Dostawy)).Cena=xDw.item(z).Cena
					Dostawy(size(Dostawy)).Ilosc=xDw.item(z).Ilosc
					Dostawy(size(Dostawy)).Wartosc=xDw.item(z).Ilosc * xDw.item(z).Cena
					Dostawy(size(Dostawy)).Nazwa=xDw.item(z).Dostawa
					Dostawy(size(Dostawy)).lp=xPozDost.Lpsuper
					Dostawy(size(Dostawy)).typ=typ
				endif
			next z
		endif
	next j
	nDostawy=size(Dostawy)
EndSub
int sub ZbierzDostawyMag(int nStat, dispatch dObiekt, long dokid, Long idPozKoryg)
dispatch xDost,xPo,xPrzed								//dokid - wykorzystywane tylko dla korekt zbiorczych
int i,k,nRes

int iLp = GeConnHnLp(IIF(idPozKoryg, idPozKoryg, dObiekt.id))

string sTmp
	if nStat!=2 then
		if bKZ then exit
		xDost=dObiekt.Wlasciwosci.Dostawy
		for i=1 to i>xDost.Count()
			if !mDst.Index( using "%s,%d,%d",xDost.item(i).dostawa,iLp,nstat)  then
				if Dostawy(size(Dostawy)).lp then grow Dostawy, 1
				mDst.Set( (using "%s,%d,%d",xDost.item(i).dostawa,iLp,nstat) ,1)
				Dostawy(size(Dostawy)).lp=iLp
				Dostawy(size(Dostawy)).typ=nstat
				Dostawy(size(Dostawy)).nazwa=xDost.item(i).dostawa
				Dostawy(size(Dostawy)).ilosc=1
				Dostawy(size(Dostawy)).iddokkoryg=dokid
				Dostawy(size(Dostawy)).iloscAkt=xDost.item(i).ilosc
			endif
		next i
	else
		If DostawyKorygowane Then
			xPrzed = dObiekt.Wlasciwosci.Dostawy
			xPo = dObiekt.Wlasciwosci.Dostawy
		Else
			xPrzed=dObiekt.PrzedKorekta.Wlasciwosci.Dostawy
			xPo=dObiekt.PoKorekcie.Wlasciwosci.Dostawy
		EndIf
		for k=1 to k>xPo.Count()
			nRes=0
			for i=1 to i>xPrzed.Count()
				if xPrzed.item(i).dostawa==xPo.item(k).dostawa then
					if xPrzed.item(i).ilosc!=xPo.item(k).ilosc || xPrzed.item(i).cena!=xPo.item(k).cena || DostawyKorygowane then
						if bKZ then
							sTmp = using "%s,%d %d,%d",xPrzed.item(i).Dostawa,dokid, iLp,nstat
						else
							sTmp = using "%s,%d,%d",xPrzed.item(i).Dostawa,iLp,nstat
						endif
						if !mDst.Index(sTmp)  then
						if Dostawy(size(Dostawy)).lp then grow Dostawy, 1
							if bKZ then
								mDst.Set( (using "%s,%d %d,%d",xPrzed.item(i).Dostawa,dokid, iLp,nstat) ,1)
							else
								mDst.Set( (using "%s,%d,%d",xPrzed.item(i).Dostawa,iLp,nstat) ,1)
							endif
							Dostawy(size(Dostawy)).lp=iLp
							Dostawy(size(Dostawy)).typ=nstat
							Dostawy(size(Dostawy)).nazwa=xPrzed.item(i).Dostawa
							Dostawy(size(Dostawy)).ilosc=1
							Dostawy(size(Dostawy)).iddokkoryg=dokid
						endif
					endif
					nRes=1 : exit
				endif
			next i
			if !nRes then
				if !mDst.Index( using "%s,%d,%d",xPo.item(i).Dostawa,iLp,nstat)  then
					if Dostawy(size(Dostawy)).lp then grow Dostawy, 1
					 mDst.Set( (using "%s,%d,%d",xPo.item(i).Dostawa,iLp,nstat) ,1)
					Dostawy(size(Dostawy)).lp=iLp
					Dostawy(size(Dostawy)).typ=nstat
					Dostawy(size(Dostawy)).nazwa=xPo.item(k).dostawa
					Dostawy(size(Dostawy)).ilosc=1
					Dostawy(size(Dostawy)).iddokkoryg=dokid
				endif
			endif
		next k
	endif
endsub
//----------------------------------------------------------------------------------------------------------------

InitFundusze()
if !BUFOR && (xBazaDok == "Zk") then
	GetWplatyNaFunduszePromocji(idDokKoryg)
endif
UtworzKorekty()
UtworzStawkiVat()
if bKZ then UtworzStawkiVatDokKor()	

for xInd=1 to xInd>xPoz.Count()
	if xPoz.item(xInd).wlasna then
	if !xPoz.item(xInd).dokompletu then
	if Przed(size(Przed)).lp then grow Przed, 1 : grow Po, 1
	UtworzPrzed_Po("B",xPoz.item(xInd).PrzedKorekta,Przed(size(Przed)) )
	if xPoz.item(xInd).PrzedKorekta.NiePodlega then
		Select case xDocument.Charakter

			case FKS,FKW,FKZ,RKZ,FKR,FKM,DKM,WNK,WKS,WKZ,ZSK,ZZK,DXK,FAK,KRW,ZKZ,ZKS,WDK,SZK,SZWK,FTK
				tot_nettoNPBaza+=xPoz.item(xInd).PrzedKorekta.NiePodlega
				tot_nettoNPBazaWAL += xPoz.item(xInd).PrzedKorekta.NiePodlegaWal
		endSelect
	endif
	tot_nettoBaza+=xPoz.item(xInd).PrzedKorekta.Netto
	tot_nettoBazaWAL += xPoz.item(xInd).PrzedKorekta.NettoWal
	tot_vatBaza+=xPoz.item(xInd).PrzedKorekta.Vat
	tot_bruttoBaza+=xPoz.item(xInd).Przedkorekta.Brutto
	tot_bruttoBazaWAL += xPoz.item(xInd).Przedkorekta.BruttoWal
	
	AddIdDokKoryg(xPoz.item(xInd).idSuperKoryg)
	// nowe pozycje korekt
	If xPoz.item(xInd).idPozKoryg == 0 Then
		AddIdDocNewPos(xPoz.item(xInd).PoKorekcie.Dokument.id)
	EndIf

	ZbierzDostawy(xPoz.item(xInd).PrzedKorekta,1)
	UtworzPrzed_Po("P",xPoz.item(xInd).PoKorekcie,Po(size(Po)) )	
	ZbierzDostawy(xPoz.item(xInd).PoKorekcie,3)
	ZbierzDostawy(xPoz.item(xInd),2)
	endif
	endif
next xInd

#ifndef KONTRAKTZ
ReadPosConnection()
#endif

#ifdef FAKTURKOR2

	// kumulujemy pozycje 'przed korekta'
	ftkIlosc = 0
	ftkWartoscBrutto = 0

	For i = 1 To i > Size( Przed )
		ftkStop = 0
		For indPos = 1 To indPos > Size( Korekty ) || ftkStop
			If Przed(i).lp == Korekty(indPos).lp && Korekty(indPos).nKorStat != 1 Then ftkIlosc += Przed(i).IloscWP : ftkWartoscBrutto += Przed(i).WartoscBrutto : ftkStop = 1
		Next indPos
	Next i

	Shrink Przed, -1
	Przed(1).IloscWP = ftkIlosc
	Przed(1).WartoscBrutto = ftkWartoscBrutto
	If Sign( Przed(1).IloscWP ) Then Przed(1).CenaWP = Round( Przed(1).WartoscBrutto / Przed(1).IloscWP, 2 )

	// kumulujemy pozycje 'po korekcie'
	ftkIlosc = 0
	ftkWartoscBrutto = 0

	For i = 1 To i > Size( Po )
		ftkStop = 0
		For indPos = 1 To indPos > Size( Korekty ) || ftkStop
			If Po(i).lp == Korekty(indPos).lp && Korekty(indPos).nKorStat != 1 Then ftkIlosc += Po(i).IloscWP :  ftkWartoscBrutto += Po(i).WartoscBrutto : ftkStop = 1
		Next indPos
	Next i

	Shrink Po, -1
	Po(1).IloscWP = ftkIlosc
	Po(1).WartoscBrutto = ftkWartoscBrutto
	If Sign( Po(1).IloscWP ) Then Po(1).CenaWP = Round( Po(1).WartoscBrutto / Po(1).IloscWP, 2 )

	// kumulujemy korekty ilosci i ceny
	For xInd = 2 To xInd > 3
		ftkIlosc = 0
		ftkWartoscBrutto = 0
		ftkPos = 0

		For i = 1 to i > Size( Korekty )
			If Korekty(i).nKorStat == xInd Then
				ftkIlosc += Korekty(i).IloscWP
				ftkWartoscBrutto += Korekty(i).WartoscBrutto
				If ftkPos == 0 Then
					// pozycja kumulujaca
					ftkPos = i
				Else
					// nie drukujemy - wystarczy oznaczyc jako korekta stawki VAT
					Korekty(i).nKorStat = 1
				EndIf
			EndIf
		Next i

		If ftkPos > 0 Then
			Korekty(ftkPos).IloscWP = ftkIlosc
			Korekty(ftkPos).WartoscBrutto = ftkWartoscBrutto
			If Sign( Korekty(ftkPos).IloscWP ) Then Korekty(ftkPos).CenaWP = Round( Korekty(ftkPos).WartoscBrutto / Korekty(ftkPos).IloscWP, 2 )
		EndIf
	Next xInd

#endif

warPodlega = sign(tot_nettoBaza,3) || sign(xDocument.Netto,3)
warNiepodlega = sign(tot_nettoNPBaza,3) || sign(xDocument.Niepodlega,3)

Int Sub ZbierzDostawyMag_Pozycje( Dispatch xDocument, long lIdDPkoryg )
													//   0 - dla wszystkich pozycji
 													// wpp - dla wskazanej pozycji
Dispatch	xMag
Dispatch	xPow
Int			i
Int			j
Int			wydlabel = 0
Int			wyjdz = 0
long		lCurrDpKoryg
xPow=xDocument.PowiazaneDk
i=1
while i<=xPow.count() && !wyjdz
	if wydlabel && xPow.item(i).typ!=2 then
		if xMag=GetObjById("BDokumentMg",xPow.item(i).dkid) then
			for j=1 to j>xMag.Pozycje.Count()
				if xMag.Pozycje.item(j).idPozKoryg then //jeli to WZK
					lCurrDpKoryg = GetConnHnId(xMag.Pozycje.item(j).idPozKoryg)
				else	//jeli to WZ
					lCurrDpKoryg = GetConnHnId(xMag.Pozycje.item(j).id)
				endif

				if lCurrDpKoryg then
					If lIdDPkoryg == 0 || lIdDPkoryg == lCurrDpKoryg Then
						if xMag.Pozycje.item(j).idPozKoryg then	//jeli to WZK
																				// PrzedKorekta..idPozKoryg wskazuje poprzednia w ciagu korekt zamiast oryginalna korygowana
							ZbierzDostawyMag(1,xMag.Pozycje.item(j).PrzedKorekta,xDocument.id,xMag.Pozycje.item(j).idPozKoryg)
							ZbierzDostawyMag(2,xMag.Pozycje.item(j),xDocument.id,xMag.Pozycje.item(j).idPozKoryg)
							ZbierzDostawyMag(3,xMag.Pozycje.item(j).PoKorekcie,xDocument.id,xMag.Pozycje.item(j).PoKorekcie.idPozKoryg)
						else	//jeli to WZ
							ZbierzDostawyMag(1,xMag.Pozycje.item(j),xDocument.id,xMag.Pozycje.item(j).idPozKoryg)
							ZbierzDostawyMag(2,xMag.Pozycje.item(j),xDocument.id,xMag.Pozycje.item(j).idPozKoryg)
							ZbierzDostawyMag(3,xMag.Pozycje.item(j),xDocument.id,xMag.Pozycje.item(j).idPozKoryg)
						endif
					EndIf
				Else
					ZbierzDostawyMag(1,xMag.Pozycje.item(j).PrzedKorekta,xDocument.id,0)
					ZbierzDostawyMag(2,xMag.Pozycje.item(j),xDocument.id,0)
					ZbierzDostawyMag(3,xMag.Pozycje.item(j).PoKorekcie,xDocument.id,0)
				endif
			next j
		endif
	else
		if xPow.item(i).typ==2  then
			if wydlabel then
				wyjdz=1
			else
				If xPow.item(i).nazwa == "INNE KOREKTY" || xPow.item(i).subtyp == 14 || ( DostawyKorygowane && xPow.item(i).nazwa == "WYDANIA" && xPow.item(i).subtyp == 3 ) Then
					wydlabel=1
				EndIf
			endif
		endif
	endif
	i+=1
wend
EndSub

ZbierzDostawyMag_Pozycje( xDocument, 0 )

nDostawy=size(Dostawy)
fMiejsceWyst()
DajNotatki()

Int Sub ZbierzDostawyKorygowaneKZ( )
	Dispatch	xPDoc				// Poprzedzajacy dokument ( korekta )
	Int			iDoc				// Biezacy dokument na liscie korekt lub faktur
	Int			iPos				// Pozycja dla ktorej zbieramy dostawy

	For iPos = 1 To iPos > xDocument.Pozycje.Count()
		For iDoc = 1 To iDoc > xDocument.DokumentyKorygowaneKZ.Count()
			If xDocument.DokumentyKorygowaneKZ.item( iDoc ).id == xDocument.Pozycje.item(iPos).idSuperKoryg Then
				Exit
			EndIf
		Next iDoc	

		xPDoc = GetObjById( "BDokument" + xBazaDok, xDocument.DokumentyKorygowaneKZ.item( iDoc ).id)
			If !xPdoc Then
				Exit
			EndIf
			DostawyKorygowane = 2
			ZbierzDostawyMag_Pozycje( xPDoc, xDocument.Pozycje.item(iPos).id )
			DostawyKorygowane = 0
	Next iPos
	nDostawy = Size( Dostawy )
EndSub

Int Sub ZbierzDostawyKorygowane( )
	
	if bKZ then
		ZbierzDostawyKorygowaneKZ()
		exit
	endif

	Dispatch	xPDoc				// Poprzedzajacy dokument ( korekta lub faktura )
	Int			iDoc				// Biezacy dokument na liscie korekt lub faktur
	Int			iPDoc				// Poprzedzajacy dokument na liscie korekt lub faktur
	Int			iPos				// Pozycja dla ktorej zbieramy dostawy

	// Znajdz biezacy dokument
	For iDoc = 1 To iDoc > xDocument.DokumentZKorektami.Count()
		If xDocument.DokumentZKorektami.item( iDoc ).Numer == xDocument.Numer Then
			Exit
		EndIf
	Next iDoc

	For iPos = 1 To iPos > xDocument.Pozycje.Count()
		// Dla kazdej pozycji szukamy dostaw wstecznie
		// Rozpoczynamy od biezacego dokumentu
		xPDoc = GetObjById( "BDokument" + xBazaDok, xDocument.DokumentZKorektami.item( iDoc ).id )
		iPDoc = iDoc - 1
		While iPDoc > 0 && xPDoc
			If xPDoc.Pozycje.item( iPos ) Then
				If xPDoc.Pozycje.item( iPos ).ilosc != 0 Then
					// Korygowano ilosc - przerywamy
					Exit
				EndIf
			EndIf
			// Znajdz wczesniejszy dokument
			xPDoc = GetObjById( "BDokument" + xBazaDok, xDocument.DokumentZKorektami.item( iPDoc ).id )
			If !xPdoc Then
				// Blad z wyznaczenie wczesniejszego dokumentu - przerywamy
				Exit
			EndIf
			If iPDoc == 1 Then
				DostawyKorygowane = 2
			EndIf
			ZbierzDostawyMag_Pozycje( xPDoc, xDocument.Pozycje.item(iPos).idPozKoryg )
			DostawyKorygowane = 0
			iPDoc -= 1
		Wend
	Next iPos
	nDostawy = Size( Dostawy )
EndSub

