@echo off
ECHO -
ECHO ---
ECHO --------------------------------------------------------
ECHO Instalacja aktualizacji systemu Sage Symfonia
ECHO --------------------------------------------------------
ECHO ---
ECHO -
rem Skrypt instaluje dll z aktualnego katalogu do GAC'a
rem Katalog w ktrym jest skrypt
set SCRIPTDIR=%~dp0
rem Katalog w jakim jestesmy w konsoli w trakcie uruchamiania skryptu
set CURRENTDIR=%CD%

rem Opis poprawki
rem TYPE %SCRIPTDIR%ReadMe.txt

rem Wykrywanie wersji Windows
for /f "tokens=4-7 delims=[.] " %%i in ('ver') do (if %%i==Version (set WIN_VER=%%j.%%k) else (set WIN_VER=%%i.%%j))
echo Wersja systemu Windows: %WIN_VER%
ECHO -
ECHO Instalowanie assembly do GAC:
ECHO -

::list of Microsoft Windows versions.
::6.3  Windows 8.1 and Windows Server 2012 
::6.2  Windows 8 
::6.1  Windows 7 
::6.0  Windows Vista 
::5.2  Windows XP Professional x64 
::5.1  Windows XP 
::5.0  Windows 2000 
::4.10 Windows 98 

rem Wybr odpowiedniego gacutil'a
IF "%WIN_VER%"=="5.1" (
SET GACUTIL=Tools\gacutil\WinXP\gacutil.exe
) ELSE IF "%WIN_VER%"=="5.2" (
SET GACUTIL=Tools\gacutil\WinXP\gacutil.exe
) ELSE SET GACUTIL=Tools\gacutil\Win7\gacutil.exe

SET GACUTIL=%SCRIPTDIR%%GACUTIL%
rem ECHO %GACUTIL%

cd /d "%SCRIPTDIR%Assemblies2GAC\"
dir /b *.*.dll > assemblyList
rem instalowanie dll do GAC'a
"%GACUTIL%" /f /il assemblyList
IF errorlevel 1 GOTO error
del assemblyList

ECHO -
ECHO ---
ECHO -
ECHO Kopiowanie plikow do katalogow:
ECHO -
IF "%CommonProgramFiles(x86)%"=="" SET CommonProgramFiles(x86)=%CommonProgramFiles%

xcopy "%SCRIPTDIR%\CommonFiles(x86)\*" "%CommonProgramFiles(x86)%\" /E /F /Y /R
IF errorlevel 1 GOTO error

goto ok
:error
ECHO -
ECHO ---
ECHO --------------------------------------------------------
ECHO UWAGA!
ECHO Aktualizacja NIE zostala zainstalowana.
ECHO Prosze uruchomic skrypt z prawami administratora.
ECHO --------------------------------------------------------
ECHO ---
ECHO -
goto end

:ok
ECHO -
ECHO ---
ECHO ---------------------------------------------
ECHO Aktualizacja zostala zainstalowana poprawnie
ECHO ---------------------------------------------
ECHO ---
ECHO -
goto end


:end
PAUSE
