@echo off
ECHO ----
ECHO -----------
ECHO -------------------------------------------------------------
ECHO Instalacja aktualizacji systemu Sage Symfonia ERP (modul FKF)
ECHO -------------------------------------------------------------
ECHO -----------
ECHO ----
rem Skrypt instaluje dll z aktualnego katalogu do katalogu Sage\Symfonia ERP\23.20
rem Katalog w ktrym jest skrypt
set SCRIPTDIR=%~dp0
rem Katalog w jakim jestesmy w konsoli w trakcie uruchamiania skryptu
set CURRENTDIR=%CD%

rem Opis poprawki
rem TYPE %SCRIPTDIR%ReadMe.txt

rem Wykrywanie wersji Windows
for /f "tokens=4-7 delims=[.] " %%i in ('ver') do (if %%i==Version (set WIN_VER=%%j.%%k) else (set WIN_VER=%%i.%%j))
echo Wersja systemu Windows: %WIN_VER%

IF NOT EXIST "%SCRIPTDIR%Assemblies2GAC\*" GOTO InstallDirectory

ECHO -
ECHO Instalowanie assembly do GAC:
ECHO -

::list of Microsoft Windows versions.
::6.3  Windows 8.1 and Windows Server 2012 
::6.2  Windows 8 
::6.1  Windows 7 
::6.0  Windows Vista 
::5.2  Windows XP Professional x64 
::5.1  Windows XP 
::5.0  Windows 2000 
::4.10 Windows 98 

rem Wybr odpowiedniego gacutil'a
IF "%WIN_VER%"=="5.1" (
SET GACUTIL=Tools\gacutil\WinXP\gacutil.exe
) ELSE IF "%WIN_VER%"=="5.2" (
SET GACUTIL=Tools\gacutil\WinXP\gacutil.exe
) ELSE SET GACUTIL=Tools\gacutil\Win7\gacutil.exe

SET GACUTIL=%SCRIPTDIR%%GACUTIL%
rem ECHO %GACUTIL%

cd /d "%SCRIPTDIR%Assemblies2GAC\"
dir /b *.*.dll > assemblyList
rem instalowanie dll do GAC'a
"%GACUTIL%" /f /il assemblyList
IF errorlevel 1 GOTO error
del assemblyList

:InstallDirectory

REM Wykrywanie 64b vs 32b
reg Query "HKLM\Hardware\Description\System\CentralProcessor\0" | find /i "x86" > NUL && set OS=32BIT || set OS=64BIT

echo Wersja systemu Windows: %OS%

IF "%OS%"=="64BIT" (
ECHO -------------------------------------------------------------
echo FKF 2023.2
ECHO -------------------------------------------------------------
call :RegImpl "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Sage\Symfonia ERP\23.20\FKF" InstallDir ) 

IF "%OS%"=="32BIT" (
ECHO -------------------------------------------------------------
echo FKF 2023.2
ECHO -------------------------------------------------------------
call :RegImpl "HKEY_LOCAL_MACHINE\SOFTWARE\Sage\Symfonia ERP\23.20\FKF" InstallDir )

ECHO --------------------------------------------------------
ECHO --- Zakonczono aktualizacje ----------------------------
ECHO --------------------------------------------------------

echo Nacisnij dowolny klawisz . . .
pause

goto end


:RegImpl
REM @echo OFF

setlocal ENABLEEXTENSIONS

set KEY_NAME="%~1"
set VALUE_NAME=%~2
set VERSION="%~3"
set FOUND=0

FOR /F "usebackq skip=2 tokens=1,2*" %%A IN (`REG QUERY %KEY_NAME% /v %VALUE_NAME% 2^>nul`) DO (
    if %%A==%VALUE_NAME% (
       Rem tutaj wiemy e zainstalowano w tej wesji
       Rem VERSION zawiera wersj (katalog) do podmiany, 
       Rem miejsce instalacji jest w %%C
       
        rem @echo Name = %%A
        rem @echo Type = %%B
        rem @echo InstallFolder = %%C 
	set FOUND=1
ECHO -------------------------------------------------------------
echo Znaleziono FKF w katalogu 
echo "%%C"	
ECHO -------------------------------------------------------------
	set MyPath=%%C
	   call :Install Install %VERSION% InstallFolder %VERSION%
    )
)
if %FOUND%==0 (
   echo Nie znaleziono FKF w katalogu "%%C"
)

exit /b
echo ##########################################################
REM -----------------------------------------------------------


:Install
echo off
REM folder z ktrego instalujemy
set "SourceFolder=%~1"
set "DestinationFolder=%~2"
set "ExeVersion=%~3"

REM kopiowanie dll'ek pod exe'ka aplikacji
ECHO ----
ECHO -----------
ECHO -------------------------------------------------------------
ECHO Kopiowanie plikow do katalogu aplikacji:
ECHO -------------------------------------------------------------

IF NOT EXIST "%SCRIPTDIR%\CommonFiles(x86)\*" GOTO Copy
IF "%CommonProgramFiles(x86)%"=="" SET CommonProgramFiles(x86)=%CommonProgramFiles%
xcopy "%SCRIPTDIR%\CommonFiles(x86)\*" "%CommonProgramFiles(x86)%\" /E /F /Y /R /S

:Copy
IF NOT EXIST "%SCRIPTDIR%\Dodatki\Copy\*" GOTO Resources
xcopy "%SCRIPTDIR%\Dodatki\Copy" "%MyPath%" /F /Y /R /S

:Resources
IF NOT EXIST "%SCRIPTDIR%\Dodatki\Resources\*" GOTO Reports
xcopy "%SCRIPTDIR%\Dodatki\Resources" "%MyPath%\Resources"  /F /Y /R /S

:Reports
IF NOT EXIST "%SCRIPTDIR%\Dodatki\Reports\*" GOTO ok
xcopy "%SCRIPTDIR%\Dodatki\Reports" "%MyPath%\Raporty"  /F /Y /R /S

IF errorlevel 1 GOTO error

goto ok


:error
ECHO ----
ECHO -----------
ECHO --------------------------------------------------------
ECHO UWAGA!
ECHO Aktualizacja wersji FKF 2023.2 NIE zostala zainstalowana.
ECHO Prosze uruchomic skrypt z prawami administratora.
ECHO --------------------------------------------------------
ECHO -----------
ECHO ----
EXIT /b

:ok
ECHO ----
ECHO -----------
ECHO --------------------------------------------------------
ECHO Aktualizacja dla wersji FKF 2023.2 zostala zainstalowana poprawnie
ECHO --------------------------------------------------------
ECHO -----------
ECHO ----

:end
